/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import com.google.inject.Inject;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementFormatter;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.formatting.impl.AbstractNodeModelFormatter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class DeclarativeFormatter
extends AbstractNodeModelFormatter {
    @Inject
    private @NonNull UserModelAnalysis modelAnalysis;
    @Inject
    private @NonNull SerializationBuilder serializationBuilder;

    public INodeModelFormatter.IFormattedRegion format(ICompositeNode root, int selectStart, int selectLength) {
        char c;
        char c2;
        ILeafNode endNode;
        assert (root != null);
        int selectEnd = selectStart + selectLength;
        ILeafNode startNode = NodeModelUtils.findLeafNodeAtOffset((INode)root, (int)selectStart);
        assert (startNode != null);
        ILeafNode iLeafNode = endNode = selectLength > 0 ? NodeModelUtils.findLeafNodeAtOffset((INode)root, (int)selectEnd) : startNode;
        assert (endNode != null);
        String oldText = root.getText();
        int oldStart = startNode.getTotalOffset();
        int oldEnd = endNode.getTotalEndOffset();
        String oldSelectedText = oldText.substring(selectStart, selectEnd);
        String oldNodeText = oldText.substring(oldStart, oldEnd);
        boolean oldFollowsNewLine = false;
        while (oldStart < oldEnd) {
            char c3 = oldText.charAt(oldStart);
            if (!Character.isWhitespace(c3)) break;
            ++oldStart;
        }
        int i = oldStart;
        while (i > 0) {
            c2 = oldText.charAt(i - 1);
            if (c2 == '\n') {
                oldStart = i;
                oldFollowsNewLine = true;
            } else if (!Character.isWhitespace(c2)) break;
            --i;
        }
        boolean oldPrecedesNewLine = false;
        while (oldStart < oldEnd) {
            c2 = oldText.charAt(oldEnd - 1);
            if (!Character.isWhitespace(c2)) break;
            --oldEnd;
        }
        int i2 = oldEnd;
        while (oldStart < i2) {
            char c4 = oldText.charAt(i2);
            if (c4 == '\n') {
                oldEnd = i2;
                oldPrecedesNewLine = true;
            } else if (!Character.isWhitespace(c4)) break;
            ++i2;
        }
        String oldConditionedText = oldText.substring(oldStart, oldEnd);
        Stack<@NonNull INode> startNodeStack = new Stack<INode>();
        ILeafNode node = startNode;
        while (node != null) {
            startNodeStack.push((INode)node);
            node = node.getParent();
        }
        boolean hasEnded = this.formatAncestry(startNodeStack, endNode);
        assert (hasEnded);
        String newText = this.serializationBuilder.toString();
        int newStart = 0;
        int newEnd = newText.length();
        if (!oldFollowsNewLine) {
            while (newStart < newEnd) {
                c = newText.charAt(newStart);
                if (!Character.isWhitespace(c)) break;
                ++newStart;
            }
        }
        if (!oldPrecedesNewLine) {
            while (newStart < newEnd) {
                c = newText.charAt(newEnd - 1);
                if (!Character.isWhitespace(c)) break;
                --newEnd;
            }
        }
        String newConditionedText = newText.substring(newStart, newEnd);
        return new AbstractNodeModelFormatter.FormattedRegion(newStart, newEnd - newStart, newConditionedText);
    }

    protected boolean formatAncestry(@NonNull Stack<@NonNull INode> startNodeStack, @NonNull ILeafNode endNode) {
        ICompositeNode parentStartNode = (ICompositeNode)startNodeStack.pop();
        INode childStartNode = startNodeStack.peek();
        EObject semanticElement = parentStartNode.getSemanticElement();
        assert (semanticElement != null);
        AbstractElement compoundedGrammarElement = this.getCompoundedGrammarElement((INode)parentStartNode);
        UserElementFormatter elementFormatter = this.modelAnalysis.createUserElementFormatter((INode)parentStartNode, compoundedGrammarElement, semanticElement);
        SerializationSegment[] serializationSegmentArray = elementFormatter.getInnerFormattingSegments();
        int n = serializationSegmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            SerializationSegment formattingSegment = serializationSegmentArray[n2];
            if (formattingSegment.isValue()) break;
            if (formattingSegment.isControl()) {
                formattingSegment.format(elementFormatter, this.serializationBuilder);
            }
            ++n2;
        }
        boolean hasStarted = false;
        boolean hasEnded = false;
        for (INode childNode : SerializationUtils.getChildren(parentStartNode)) {
            if (!hasStarted && childNode == childStartNode) {
                hasStarted = true;
                hasEnded = childStartNode instanceof ICompositeNode ? this.formatAncestry(startNodeStack, endNode) : this.formatNode(childNode, hasStarted, endNode);
            } else {
                hasEnded = this.formatNode(childNode, hasStarted, endNode);
            }
            if (hasEnded) break;
        }
        assert (hasStarted);
        boolean isTail = false;
        SerializationSegment[] serializationSegmentArray2 = elementFormatter.getInnerFormattingSegments();
        int n3 = serializationSegmentArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            SerializationSegment formattingSegment = serializationSegmentArray2[n4];
            if (!isTail) {
                if (formattingSegment.isValue()) {
                    isTail = true;
                }
            } else if (formattingSegment.isControl()) {
                formattingSegment.format(elementFormatter, this.serializationBuilder);
            }
            ++n4;
        }
        return hasEnded;
    }

    protected boolean formatCompositeNode(@NonNull ICompositeNode compositeNode, boolean hasStarted, @NonNull ILeafNode endNode) {
        INode nextSibling;
        SerializationSegment[] innerFormattingSegments;
        int n;
        INode prevSibling;
        String text = compositeNode.getText();
        assert (text != null);
        EObject semanticElement = compositeNode.getSemanticElement();
        assert (semanticElement != null);
        AbstractElement compoundedGrammarElement = this.getCompoundedGrammarElement((INode)compositeNode);
        EList<?> assignedCollection = this.getAssignedCollection(compositeNode, compoundedGrammarElement);
        UserElementFormatter elementFormatter = this.modelAnalysis.createUserElementFormatter((INode)compositeNode, compoundedGrammarElement, semanticElement);
        EList<?> prevAssignedCollection = null;
        if (assignedCollection != null && (prevSibling = compositeNode.getPreviousSibling()) instanceof ICompositeNode) {
            prevAssignedCollection = this.getAssignedCollection((ICompositeNode)prevSibling, this.getCompoundedGrammarElement(prevSibling));
        }
        if (assignedCollection == null || assignedCollection != prevAssignedCollection) {
            SerializationSegment[] outerFormattingSegments;
            SerializationSegment[] serializationSegmentArray = outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
            n = outerFormattingSegments.length;
            int n2 = 0;
            while (n2 < n) {
                SerializationSegment formattingSegment = serializationSegmentArray[n2];
                if (formattingSegment.isValue()) break;
                formattingSegment.format(elementFormatter, this.serializationBuilder);
                ++n2;
            }
        }
        boolean hasEnded = false;
        SerializationSegment[] serializationSegmentArray = innerFormattingSegments = elementFormatter.getInnerFormattingSegments();
        int n3 = innerFormattingSegments.length;
        n = 0;
        while (n < n3) {
            SerializationSegment formattingSegment = serializationSegmentArray[n];
            if (formattingSegment.isValue()) {
                for (INode childNode : SerializationUtils.getChildren(compositeNode)) {
                    if (!this.formatNode(childNode, hasStarted, endNode)) continue;
                    hasEnded = true;
                    break;
                }
            } else if (hasStarted) {
                formattingSegment.format(elementFormatter, this.serializationBuilder);
            }
            ++n;
        }
        EList<?> nextAssignedCollection = null;
        if (assignedCollection != null && (nextSibling = compositeNode.getNextSibling()) instanceof ICompositeNode) {
            nextAssignedCollection = this.getAssignedCollection((ICompositeNode)nextSibling, this.getCompoundedGrammarElement(nextSibling));
        }
        if (assignedCollection == null || assignedCollection != nextAssignedCollection) {
            SerializationSegment[] outerFormattingSegments;
            boolean isTail = false;
            SerializationSegment[] serializationSegmentArray2 = outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
            int n4 = outerFormattingSegments.length;
            int n5 = 0;
            while (n5 < n4) {
                SerializationSegment formattingSegment = serializationSegmentArray2[n5];
                if (!isTail) {
                    if (formattingSegment.isValue()) {
                        isTail = true;
                    }
                } else {
                    formattingSegment.format(elementFormatter, this.serializationBuilder);
                }
                ++n5;
            }
        }
        return hasEnded;
    }

    protected void formatLeafNode(@NonNull ILeafNode leafNode, boolean hasStarted) {
        String text = leafNode.getText();
        assert (text != null);
        if (!leafNode.isHidden()) {
            SerializationSegment[] innerFormattingSegments;
            EObject semanticElement = leafNode.getSemanticElement();
            assert (semanticElement != null);
            AbstractElement compoundedGrammarElement = this.getCompoundedGrammarElement((INode)leafNode);
            UserElementFormatter elementFormatter = this.modelAnalysis.createUserElementFormatter((INode)leafNode, compoundedGrammarElement, semanticElement);
            INode prevSibling = leafNode.getPreviousSibling();
            block0: while (prevSibling == null || prevSibling instanceof ILeafNode) {
                if (prevSibling == null || !((ILeafNode)prevSibling).isHidden()) {
                    SerializationSegment[] outerFormattingSegments;
                    AbstractElement prevCompoundedGrammarElement;
                    AbstractElement abstractElement = prevCompoundedGrammarElement = prevSibling != null ? this.getCompoundedGrammarElement(prevSibling) : null;
                    if (compoundedGrammarElement == prevCompoundedGrammarElement) break;
                    SerializationSegment[] serializationSegmentArray = outerFormattingSegments = elementFormatter.getOuterFormattingSegments();
                    int n = outerFormattingSegments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SerializationSegment formattingSegment = serializationSegmentArray[n2];
                        if (formattingSegment.isValue()) break block0;
                        formattingSegment.format(elementFormatter, this.serializationBuilder);
                        ++n2;
                    }
                    break;
                }
                prevSibling = prevSibling.getPreviousSibling();
            }
            SerializationSegment[] serializationSegmentArray = innerFormattingSegments = elementFormatter.getInnerFormattingSegments();
            int formattingSegment = innerFormattingSegments.length;
            int outerFormattingSegments = 0;
            while (outerFormattingSegments < formattingSegment) {
                SerializationSegment formattingSegment2 = serializationSegmentArray[outerFormattingSegments];
                if (hasStarted || formattingSegment2.isControl()) {
                    formattingSegment2.format(elementFormatter, this.serializationBuilder);
                }
                ++outerFormattingSegments;
            }
            INode nextSibling = leafNode.getNextSibling();
            while (nextSibling == null || nextSibling instanceof ILeafNode) {
                if (nextSibling == null || !((ILeafNode)nextSibling).isHidden()) {
                    SerializationSegment[] outerFormattingSegments2;
                    AbstractElement nextCompoundedGrammarElement;
                    AbstractElement abstractElement = nextCompoundedGrammarElement = nextSibling != null ? this.getCompoundedGrammarElement(nextSibling) : null;
                    if (compoundedGrammarElement == nextCompoundedGrammarElement) break;
                    boolean isTail = false;
                    SerializationSegment[] serializationSegmentArray2 = outerFormattingSegments2 = elementFormatter.getOuterFormattingSegments();
                    int n = outerFormattingSegments2.length;
                    int n3 = 0;
                    while (n3 < n) {
                        SerializationSegment formattingSegment3 = serializationSegmentArray2[n3];
                        if (!isTail) {
                            if (formattingSegment3.isValue()) {
                                isTail = true;
                            }
                        } else {
                            formattingSegment3.format(elementFormatter, this.serializationBuilder);
                        }
                        ++n3;
                    }
                    break;
                }
                nextSibling = nextSibling.getNextSibling();
            }
        }
    }

    protected boolean formatNode(@NonNull INode childNode, boolean hasStarted, @NonNull ILeafNode endNode) {
        if (childNode instanceof ICompositeNode) {
            if (this.formatCompositeNode((ICompositeNode)childNode, hasStarted, endNode)) {
                return true;
            }
        } else {
            if (!((ILeafNode)childNode).isHidden()) {
                this.formatLeafNode((ILeafNode)childNode, hasStarted);
            }
            if (childNode == endNode) {
                return true;
            }
        }
        return false;
    }

    protected @Nullable EList<?> getAssignedCollection(@NonNull ICompositeNode compositeNode, @NonNull AbstractElement compoundedGrammarElement) {
        if (!(compoundedGrammarElement instanceof Assignment)) {
            return null;
        }
        EStructuralFeature eStructuralFeature = SerializationUtils.getEStructuralFeature((Assignment)compoundedGrammarElement);
        if (!eStructuralFeature.isMany()) {
            return null;
        }
        ICompositeNode parentNode = compositeNode.getParent();
        EObject parentSemanticElement = parentNode.getSemanticElement();
        return (EList)parentSemanticElement.eGet(eStructuralFeature);
    }

    protected @NonNull AbstractElement getCompoundedGrammarElement(@NonNull INode node) {
        EObject grammarElement = node.getGrammarElement();
        EObject eContainer = grammarElement.eContainer();
        while (eContainer instanceof AbstractElement && !(eContainer instanceof CompoundElement)) {
            grammarElement = eContainer;
            eContainer = grammarElement.eContainer();
        }
        return grammarElement instanceof AbstractElement ? (AbstractElement)grammarElement : SerializationUtils.getAlternatives((AbstractRule)grammarElement);
    }
}

