/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.factory.IAxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.wizard.AbstractTableWizard;
import org.eclipse.papyrus.infra.nattable.wizard.CategoriesWizardUtils;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ConfigurePastePage;
import org.eclipse.papyrus.infra.nattable.wizard.pages.SelectCategoriesWizardPage;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.FlattenableRestrictedFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ConfigureTableCategoriesWizard
extends AbstractTableWizard
implements IPageChangedListener {
    private SelectCategoriesWizardPage categoriesPage;
    private ConfigurePastePage pastePage;
    private INattableModelManager manager;
    private final NatTable natTable;
    private List<Object> initialSelection;

    public ConfigureTableCategoriesWizard(INattableModelManager manager) {
        this.manager = manager;
        this.natTable = (NatTable)manager.getAdapter(NatTable.class);
        this.setWindowTitle(Messages.ConfigureTableCategoriesWizard_ConfigureCategoriesAndPaste);
        this.initialSelection = this.createInitialSelection();
    }

    protected IStaticContentProvider createSelectorContentProvider(ReferenceSelector selector) {
        IAxisManager editedAxisManager = this.manager.getColumnAxisManager();
        IRestrictedContentProvider provider = editedAxisManager.createPossibleAxisContentProvider(true);
        Assert.isNotNull((Object)provider);
        return new FlattenableRestrictedFilteredContentProvider(provider, selector){

            public boolean isValidValue(Object element) {
                return element instanceof EReference && element != EcorePackage.eINSTANCE.getEModelElement_EAnnotations();
            }
        };
    }

    protected ReferenceSelector createReferenceSelector() {
        ReferenceSelector selector = new ReferenceSelector(false){

            public void createControls(Composite parent) {
                super.createControls(parent);
                this.treeViewer.setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider();
        selector.setLabelProvider(labelProvider);
        selector.setContentProvider(this.createSelectorContentProvider(selector));
        return selector;
    }

    protected SelectCategoriesWizardPage createSelectCategoriesPage() {
        this.categoriesPage = new SelectCategoriesWizardPage((IElementSelector)this.createReferenceSelector());
        LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        this.categoriesPage.setLabelProvider(new ITreeItemWrappedObjectLabelProvider(serv.getLabelProvider(), this.natTable));
        this.categoriesPage.setInitialElementSelections(this.initialSelection);
        return this.categoriesPage;
    }

    protected ConfigurePastePage createConfigurePastePage() {
        LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        this.pastePage = new ConfigurePastePage("Paste Configuration", this.manager, new ITreeItemWrappedObjectLabelProvider(serv.getLabelProvider(), this.natTable), serv.getLabelProvider(), this.createSelectorContentProvider(null));
        return this.pastePage;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.createSelectCategoriesPage());
        this.addPage((IWizardPage)this.createConfigurePastePage());
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
    }

    protected List<Object> createInitialSelection() {
        Table table = this.manager.getTable();
        EObject tableContext = table.getContext();
        ArrayList<Object> initialSelection = new ArrayList<Object>();
        for (AxisManagerRepresentation rep : ConfigureTableCategoriesWizard.getRowAxisManagerRepresentations(table)) {
            HashMap<Object, ITreeItemAxis> map = new HashMap<Object, ITreeItemAxis>();
            ITreeItemAxis rootAxis = IAxisFactory.createITreeItemAxis(null, (Object)tableContext, (AxisManagerRepresentation)rep, null);
            map.put(tableContext, rootAxis);
            initialSelection.add(rootAxis);
            for (TreeFillingConfiguration fillingConf : FillingConfigurationUtils.getTreeFillingConfiguration(table, rep)) {
                Integer depth = fillingConf.getDepth();
                ITreeItemAxis axis = (ITreeItemAxis)map.get(depth);
                if (axis == null) {
                    axis = IAxisFactory.createITreeItemAxis((ITreeItemAxis)rootAxis, (Object)depth, null, null);
                    map.put(depth, axis);
                }
                Object representedElement = fillingConf.getAxisUsedAsAxisProvider().getElement();
                for (ITreeItemAxis curr : axis.getChildren()) {
                    if (curr.getElement() != representedElement) continue;
                }
                ITreeItemAxis categoryAxis = IAxisFactory.createITreeItemAxis((ITreeItemAxis)axis, (Object)representedElement, null, (String)fillingConf.getAxisUsedAsAxisProvider().getAlias());
                if (fillingConf.getPasteConfiguration() == null) continue;
                IAxisFactory.createITreeItemAxis((ITreeItemAxis)categoryAxis, (Object)fillingConf.getPasteConfiguration(), null, null);
            }
            if (map.get(0) != null) continue;
            ITreeItemAxis axis = IAxisFactory.createITreeItemAxis((ITreeItemAxis)rootAxis, (Object)0, null, null);
            map.put(0, axis);
            rootAxis.getChildren().move(0, (Object)axis);
        }
        return initialSelection;
    }

    public boolean performFinish() {
        Table table = this.manager.getTable();
        ArrayList<ITreeItemAxis> configureCategoriesResult = new ArrayList<ITreeItemAxis>();
        Map<ITreeItemAxis, PasteEObjectConfiguration> pasteConfigurations = this.pastePage.getPasteConfigurations();
        for (Object curr : this.initialSelection) {
            configureCategoriesResult.add((ITreeItemAxis)curr);
        }
        Command cmd = this.getConfigureCategoriesCommand(configureCategoriesResult, pasteConfigurations);
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(table);
        domain.getCommandStack().execute(cmd);
        return true;
    }

    private ILabelProviderConfiguration getLabelConfigurationForTreeFillingConfiguration(Table table) {
        TableHeaderAxisConfiguration conf = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        for (IAxisConfiguration tmp : conf.getOwnedAxisConfigurations()) {
            if (!(tmp instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)tmp).getLabelProvider() == null) continue;
            return ((TreeFillingConfiguration)tmp).getLabelProvider();
        }
        return null;
    }

    private String getLabelProviderContextForTreeFillingConfiguration(Table table) {
        return "org.eclipse.papyrus.infra.nattable.header.treefilling.feature.labelprovider";
    }

    protected Command getConfigureCategoriesCommand(final List<ITreeItemAxis> userSelection, final Map<ITreeItemAxis, PasteEObjectConfiguration> pasteConfigurations) {
        return new RecordingCommand(TableEditingDomainUtils.getTableEditingDomain(this.manager.getTable())){

            protected void doExecute() {
                Table table = ConfigureTableCategoriesWizard.this.manager.getTable();
                for (Object tmp : userSelection) {
                    ITreeItemAxis root = (ITreeItemAxis)tmp;
                    AxisManagerRepresentation representation = root.getManager();
                    ArrayList<TreeFillingConfiguration> createdFillingConfiguration = new ArrayList<TreeFillingConfiguration>();
                    ArrayList<PasteEObjectConfiguration> createdPasteEObjectConfiguration = new ArrayList<PasteEObjectConfiguration>();
                    for (ITreeItemAxis depthItem : root.getChildren()) {
                        Assert.isTrue((boolean)CategoriesWizardUtils.isDepthItem(depthItem));
                        int wantedDepth = Integer.valueOf((String)depthItem.getElement());
                        if (depthItem.getChildren().isEmpty()) {
                            if (pasteConfigurations.get(depthItem) == null) continue;
                            createdPasteEObjectConfiguration.add((PasteEObjectConfiguration)pasteConfigurations.get(depthItem));
                            continue;
                        }
                        for (ITreeItemAxis categoryItem : depthItem.getChildren()) {
                            TreeFillingConfiguration newConf = ConfigureTableCategoriesWizard.findExistingTreeFillingConfiguration(table, representation, wantedDepth, categoryItem.getElement());
                            if (newConf == null || EMFHelper.isReadOnly((EObject)newConf) || pasteConfigurations.get(categoryItem) != null) {
                                PasteEObjectConfiguration copiedEObjectConfiguration = null;
                                if (pasteConfigurations.get(categoryItem) != null) {
                                    copiedEObjectConfiguration = (PasteEObjectConfiguration)pasteConfigurations.get(categoryItem);
                                } else if (newConf != null) {
                                    PasteEObjectConfiguration existingPasteConfiguration = newConf.getPasteConfiguration();
                                    copiedEObjectConfiguration = (PasteEObjectConfiguration)EcoreUtil.copy((EObject)existingPasteConfiguration);
                                }
                                if (copiedEObjectConfiguration != null) {
                                    createdPasteEObjectConfiguration.add(copiedEObjectConfiguration);
                                }
                                newConf = NattableaxisconfigurationFactory.eINSTANCE.createTreeFillingConfiguration();
                                newConf.setDepth(wantedDepth);
                                FeatureAxis axis = IAxisFactory.createAxisForFeature((Object)categoryItem.getElement(), (AxisManagerRepresentation)representation, (String)categoryItem.getAlias());
                                newConf.setAxisUsedAsAxisProvider((IAxis)axis);
                                newConf.setLabelProvider(ConfigureTableCategoriesWizard.this.getLabelConfigurationForTreeFillingConfiguration(table));
                                newConf.setLabelProviderContext(ConfigureTableCategoriesWizard.this.getLabelProviderContextForTreeFillingConfiguration(table));
                                newConf.setPasteConfiguration(copiedEObjectConfiguration);
                            } else if (newConf != null) {
                                String oldAlias = newConf.getAxisUsedAsAxisProvider().getAlias();
                                String newAlias = categoryItem.getAlias();
                                if (oldAlias != null && !oldAlias.equals(newAlias) || newAlias != null && !newAlias.equals(oldAlias)) {
                                    newConf.getAxisUsedAsAxisProvider().setAlias(newAlias);
                                }
                                if (newConf.getPasteConfiguration() != null) {
                                    createdPasteEObjectConfiguration.add(newConf.getPasteConfiguration());
                                }
                            }
                            createdFillingConfiguration.add(newConf);
                        }
                    }
                    LocalTableHeaderAxisConfiguration local = (LocalTableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTable(table);
                    if (local == null) {
                        local = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table));
                        table.setLocalRowHeaderAxisConfiguration(local);
                    }
                    EList axisManagerConfigurations = local.getAxisManagerConfigurations();
                    AxisManagerConfiguration wantedAxisManagerConfiguration = null;
                    for (AxisManagerConfiguration curr : axisManagerConfigurations) {
                        if (curr.getAxisManager() != representation) continue;
                        wantedAxisManagerConfiguration = curr;
                    }
                    if (wantedAxisManagerConfiguration == null) {
                        wantedAxisManagerConfiguration = NattableaxisconfigurationFactory.eINSTANCE.createAxisManagerConfiguration();
                        wantedAxisManagerConfiguration.setAxisManager(representation);
                        local.getAxisManagerConfigurations().add((Object)wantedAxisManagerConfiguration);
                    }
                    local.getOwnedAxisConfigurations().clear();
                    local.getOwnedAxisConfigurations().addAll(createdFillingConfiguration);
                    local.getOwnedAxisConfigurations().addAll(createdPasteEObjectConfiguration);
                    wantedAxisManagerConfiguration.getLocalSpecificConfigurations().clear();
                    wantedAxisManagerConfiguration.getLocalSpecificConfigurations().addAll(createdFillingConfiguration);
                }
            }
        };
    }

    public static final TreeFillingConfiguration findExistingTreeFillingConfiguration(Table table, AxisManagerRepresentation representedAxisManager, int depth, Object representedObject) {
        List<TreeFillingConfiguration> existingConf = FillingConfigurationUtils.getTreeFillingConfigurationForDepth(table, representedAxisManager, depth);
        for (TreeFillingConfiguration treeFillingConfiguration : existingConf) {
            if (!treeFillingConfiguration.getAxisUsedAsAxisProvider().getElement().equals(representedObject)) continue;
            return treeFillingConfiguration;
        }
        return null;
    }

    private static final List<AxisManagerRepresentation> getRowAxisManagerRepresentations(Table table) {
        AbstractHeaderAxisConfiguration tmp = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration(table);
        Assert.isTrue((boolean)(tmp instanceof TableHeaderAxisConfiguration));
        TableHeaderAxisConfiguration conf = (TableHeaderAxisConfiguration)tmp;
        return conf.getAxisManagers();
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage().equals((Object)this.pastePage)) {
            this.pastePage.setInitialElementSelections(this.initialSelection);
        }
    }

    private static class ITreeItemWrappedObjectLabelProvider
    implements ILabelProvider {
        private ILabelProvider wrappedLabelprovider;
        private NatTable natTable;
        private LabelProviderContextElementWrapper wrapper;

        public ITreeItemWrappedObjectLabelProvider(ILabelProvider wrappedProvider, NatTable natTable) {
            this.wrappedLabelprovider = wrappedProvider;
            this.natTable = natTable;
            this.wrapper = new LabelProviderContextElementWrapper();
            this.wrapper.setConfigRegistry(natTable.getConfigRegistry());
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getImage(Object arg0) {
            Object current = arg0;
            if (arg0 instanceof ITreeItemAxis) {
                current = ((ITreeItemAxis)arg0).getElement();
            }
            return this.wrappedLabelprovider.getImage(current);
        }

        public String getText(Object arg0) {
            Assert.isTrue((boolean)(arg0 instanceof ITreeItemAxis));
            ITreeItemAxis axis = (ITreeItemAxis)arg0;
            Object element = axis.getElement();
            if (element instanceof String && TypeUtils.isNaturalValue((String)((String)element))) {
                Integer value = Integer.parseInt((String)element);
                int depth = value;
                if (depth == 0 && axis.getChildren().isEmpty()) {
                    return NLS.bind((String)Messages.ConfigureTableCategoriesWizard_DepthFilledByUser, (Object)depth);
                }
                return NLS.bind((String)Messages.ConfigureTableCategoriesWizard_Depth, (Object)depth);
            }
            this.wrapper.setObject(axis);
            LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
            ILabelProvider p = serv.getLabelProvider((Object)this.wrapper);
            p = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider");
            return p.getText((Object)this.wrapper);
        }
    }
}

