/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.services.status;

import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressDialog
extends IconAndMessageDialog {
    private Image image = this.getInfoImage();
    private String title;
    private ProgressBar progressBar;
    private Label subTaskLabel;

    public ProgressDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.message = message;
        this.title = title;
        this.setShellStyle(ProgressDialog.getDefaultOrientation() | 0x800 | 0x20 | 0x10000 | 0x40);
        this.setBlockOnOpen(false);
    }

    protected Image getImage() {
        return this.image;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createMessageArea(parent);
        this.progressBar = new ProgressBar(parent, 65536);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 2;
        this.progressBar.setLayoutData((Object)gd2);
        this.progressBar.setMaximum(4);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 4;
        gd3.grabExcessHorizontalSpace = true;
        gd3.horizontalSpan = 2;
        this.subTaskLabel = new Label(parent, 64);
        this.subTaskLabel.setText("Start operation");
        this.subTaskLabel.setLayoutData((Object)gd3);
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public void work(String subTaskMessage) {
        this.progressBar.setState(0);
        int sel = this.progressBar.getSelection();
        this.progressBar.setSelection(sel + 1);
        this.subTaskLabel.setText(subTaskMessage);
    }
}

