/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.figure.nodes;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;
import org.eclipse.swt.graphics.Image;

public class LollipopInterfaceFigure
extends RoundedCompartmentFigure
implements IPapyrusNodeUMLElementFigure {
    protected int arcStarting = 0;
    protected boolean isRequired = false;
    protected boolean isProvided = false;

    public LollipopInterfaceFigure() {
        this.setShadow(false);
        this.setBorder(null);
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public void setBorder(Border border) {
        super.setBorder(null);
    }

    public void setProvided(boolean provided) {
        this.isProvided = provided;
    }

    public void setOrientation(int positionConstants) {
        if (positionConstants == 4) {
            this.arcStarting = 180;
        }
        if (positionConstants == 20) {
            this.arcStarting = 225;
        }
        if (positionConstants == 16) {
            this.arcStarting = 270;
        }
        if (positionConstants == 17) {
            this.arcStarting = 315;
        }
        if (positionConstants == 1) {
            this.arcStarting = 0;
        }
        if (positionConstants == 9) {
            this.arcStarting = 45;
        }
        if (positionConstants == 8) {
            this.arcStarting = 90;
        }
        if (positionConstants == 12) {
            this.arcStarting = 135;
        }
        this.repaint();
    }

    public void paintFigure(Graphics graphics) {
        if (this.isRequired && !this.isProvided) {
            graphics.pushState();
            graphics.setAntialias(1);
            Rectangle area = this.getBounds();
            graphics.setLineWidth(1);
            graphics.drawArc(area.x, area.y, area.width - 1, area.height - 1, this.arcStarting, 180);
            graphics.popState();
        } else if (!this.isRequired && this.isProvided) {
            graphics.pushState();
            graphics.setAntialias(1);
            graphics.setLineWidth(1);
            Rectangle area = this.getBounds();
            graphics.drawOval(area.x, area.y, area.width - 1, area.height - 1);
            graphics.popState();
        } else if (this.isRequired && this.isProvided) {
            graphics.pushState();
            graphics.setAntialias(1);
            graphics.setLineWidth(1);
            Rectangle area = this.getBounds();
            graphics.drawOval(area.x + 2, area.y + 2, area.width - 5, area.height - 5);
            graphics.drawArc(area.x, area.y, area.width - 1, area.height - 1, this.arcStarting, 180);
            graphics.popState();
        } else {
            graphics.pushState();
            graphics.setAntialias(1);
            graphics.setLineWidth(1);
            Rectangle area = this.getBounds();
            graphics.drawOval(area.x, area.y, area.width - 1, area.height - 1);
            graphics.popState();
        }
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
    }

    public PapyrusWrappingLabel getStereotypesLabel() {
        return null;
    }
}

