/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.direct.preferences;

import java.util.Arrays;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.direct.preferences.Preferences;

public class PreferencesUtil {
    public static final String AUTO_BUILDING_PLUGIN = "org.eclipse.core.resources";
    public static final String AUTO_BUILDING_KEY = "description.autobuilding";
    public static final String OPEN_ASSOCIATED_PERSPECTIVE_PLUGIN = "org.eclipse.ui.ide";
    public static final String OPEN_ASSOCIATED_PERSPECTIVE_KEY = "SWITCH_PERSPECTIVE_ON_PROJECT_CREATION";
    public static final String CONSOLE_PLUGIN = "org.eclipse.debug.ui";
    public static final String CONSOLE_LIMIT_OUTPUT_KEY = "Console.limitConsoleOutput";
    public static final String CONSOLE_LIMIT_OUTPUT_LOW_KEY = "Console.lowWaterMark";
    public static final String CONSOLE_LIMIT_OUTPUT_HIGH_KEY = "Console.highWaterMark";
    public static final String CONSOLE_OPEN_ON_ERR_KEY = "DEBUG.consoleOpenOnErr";
    public static final String CONSOLE_OPEN_ON_OUT_KEY = "DEBUG.consoleOpenOnOut";
    private static final Logger log = Logger.getLogger(PreferencesUtil.class);

    public static boolean isAutoBuildingOn() {
        return "true".equalsIgnoreCase(Preferences.get(AUTO_BUILDING_PLUGIN, AUTO_BUILDING_KEY));
    }

    public static void setAutoBuildingOn() {
        log.info("Setting the auto building ON.");
        Preferences.set(AUTO_BUILDING_PLUGIN, AUTO_BUILDING_KEY, "true");
    }

    public static void setAutoBuildingOff() {
        log.info("Setting the auto building OFF.");
        Preferences.set(AUTO_BUILDING_PLUGIN, AUTO_BUILDING_KEY, "false");
    }

    public static String getOpenAssociatedPerspective() {
        return Preferences.get(OPEN_ASSOCIATED_PERSPECTIVE_PLUGIN, OPEN_ASSOCIATED_PERSPECTIVE_KEY);
    }

    public static void setOpenAssociatedPerspective(String value) {
        PreferencesUtil.oneOf(value, "always", "never", "prompt");
        Preferences.set(OPEN_ASSOCIATED_PERSPECTIVE_PLUGIN, OPEN_ASSOCIATED_PERSPECTIVE_KEY, value);
    }

    public static boolean isConsoleOutputLimited() {
        return "true".equalsIgnoreCase(Preferences.get(CONSOLE_PLUGIN, CONSOLE_LIMIT_OUTPUT_KEY));
    }

    public static void setConsoleOutputLimited(boolean limited) {
        Preferences.set(CONSOLE_PLUGIN, CONSOLE_LIMIT_OUTPUT_KEY, String.valueOf(limited));
    }

    public static int getConsoleOutputSize() {
        return Integer.valueOf(Preferences.get(CONSOLE_PLUGIN, CONSOLE_LIMIT_OUTPUT_LOW_KEY));
    }

    public static void setConsoleOutputSize(int size) {
        PreferencesUtil.setConsoleOutputLimited(true);
        Preferences.set(CONSOLE_PLUGIN, CONSOLE_LIMIT_OUTPUT_LOW_KEY, String.valueOf(size));
        Preferences.set(CONSOLE_PLUGIN, CONSOLE_LIMIT_OUTPUT_HIGH_KEY, String.valueOf(size + 8000));
    }

    public static boolean isConsoleOpenedOnError() {
        return "true".equalsIgnoreCase(Preferences.get(CONSOLE_PLUGIN, CONSOLE_OPEN_ON_ERR_KEY));
    }

    public static boolean isConsoleOpenedOnOutput() {
        return "true".equalsIgnoreCase(Preferences.get(CONSOLE_PLUGIN, CONSOLE_OPEN_ON_OUT_KEY));
    }

    public static void setConsoleOpenedOnError(boolean openOnError) {
        log.info("Sets the console open on error to '" + openOnError + "'");
        Preferences.set(CONSOLE_PLUGIN, CONSOLE_OPEN_ON_ERR_KEY, String.valueOf(openOnError));
    }

    public static void setConsoleOpenedOnOutput(boolean openOnOutput) {
        log.info("Sets the console open on error to '" + openOnOutput + "'");
        Preferences.set(CONSOLE_PLUGIN, CONSOLE_OPEN_ON_OUT_KEY, String.valueOf(openOnOutput));
    }

    private static String oneOf(String text, String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string == null && text == null) {
                return text;
            }
            if (string != null && string.equals(text)) {
                return text;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Expected one of " + Arrays.toString(strings) + " but was '" + text + "'");
    }
}

