/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BracketEdgeStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.migration.RepairGMFbendpointsMigrationParticipant;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.RectilinearEdgeUtil;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.osgi.framework.Version;

public class RepairEdgesWithOneBendpointMigrationParticipant
extends RepairGMFbendpointsMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.5.0.202104070943");

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    @Override
    protected String getMessageMigrationParticipantTitle() {
        return Messages.RepairEdgesWithOneBendpointMigrationParticipant_title;
    }

    @Override
    protected String getMessageEdgesModified(DDiagram dDiagram) {
        return MessageFormat.format(Messages.RepairEdgesWithOneBendpointMigrationParticipant_edgesModified, dDiagram.getName());
    }

    @Override
    protected boolean checkAndRepairBendpointsOfEdge(Edge edge) {
        List pointList;
        IdentityAnchor tgtAnchor;
        boolean isEdgeModified = false;
        View source = edge.getSource();
        IdentityAnchor srcAnchor = edge.getSourceAnchor() instanceof IdentityAnchor ? (IdentityAnchor)edge.getSourceAnchor() : null;
        View target = edge.getTarget();
        IdentityAnchor identityAnchor = tgtAnchor = edge.getTargetAnchor() instanceof IdentityAnchor ? (IdentityAnchor)edge.getTargetAnchor() : null;
        if (source != null && target != null && edge.getBendpoints() instanceof RelativeBendpoints && (pointList = ((RelativeBendpoints)edge.getBendpoints()).getPoints()).size() <= 1) {
            if (edge.getElement() instanceof DEdge && ((DEdge)edge.getElement()).getOwnedStyle() instanceof BracketEdgeStyle) {
                return isEdgeModified;
            }
            Point srcRef = this.getAnchorPoint(srcAnchor, source);
            Point tgtRef = this.getAnchorPoint(tgtAnchor, target);
            Rectangle srcBounds = (Rectangle)GMFHelper.getAbsoluteBounds(source).get();
            Rectangle tgtBounds = (Rectangle)GMFHelper.getAbsoluteBounds(target).get();
            isEdgeModified = this.repairBendpointsOfEdge(edge, srcBounds, srcRef, tgtBounds, tgtRef);
        }
        return isEdgeModified;
    }

    private Point getAnchorPoint(IdentityAnchor anchor, View view) {
        Point result = null;
        if (anchor != null) {
            result = this.getAnchorPosition(anchor, view);
        } else if (view instanceof Node) {
            Node node = (Node)view;
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            result = new Point(bounds.getX(), bounds.getY());
        } else if (view instanceof Edge) {
            Edge edge = (Edge)view;
            Point sourcePoint = this.getAnchorPosition((IdentityAnchor)edge.getSourceAnchor(), (View)edge);
            Point targetPoint = this.getAnchorPosition((IdentityAnchor)edge.getTargetAnchor(), (View)edge);
            result = new Point((sourcePoint.x + targetPoint.x) / 2, (sourcePoint.y + targetPoint.y) / 2);
        }
        return result;
    }

    @Override
    protected boolean repairBendpointsOfEdge(Edge edge, Rectangle srcBounds, Point srcRef, Rectangle tgtBounds, Point tgtRef) {
        boolean isEdgeModified = false;
        PointList newPointList = new PointList();
        Point srcConnectionBendpoint = GraphicalHelper.getIntersection((Point)srcRef, (Point)tgtRef, (Rectangle)srcBounds, (boolean)true, (boolean)true).orElse(srcRef);
        Point tgtConnectionBendpoint = GraphicalHelper.getIntersection((Point)srcRef, (Point)tgtRef, (Rectangle)tgtBounds, (boolean)false, (boolean)true).orElse(tgtRef);
        if (srcConnectionBendpoint != null && tgtConnectionBendpoint != null) {
            isEdgeModified = true;
            EdgeQuery edgeQuery = new EdgeQuery(edge);
            Routing routingStyle = edgeQuery.getRoutingStyle();
            if (Routing.RECTILINEAR_LITERAL.equals(routingStyle) && srcBounds != null && srcBounds.equals((Object)tgtBounds)) {
                newPointList = RectilinearEdgeUtil.computeRectilinearBendpointsSameSourceAndTarget(srcBounds, srcBounds.getRight(), 16);
            } else if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                newPointList = RectilinearEdgeUtil.computeRectilinearBendpoints(srcBounds, tgtBounds, srcConnectionBendpoint, tgtConnectionBendpoint);
            } else {
                newPointList.addPoint(srcConnectionBendpoint);
                newPointList.addPoint(tgtConnectionBendpoint);
            }
            newPointList = RectilinearEdgeUtil.normalizeToStraightLineTolerance(newPointList, 2);
            this.setNewBendPoints(edge, srcRef, tgtRef, newPointList);
        }
        return isEdgeModified;
    }
}

