/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassUiContentProvider;

public class MultiTargetRunnable
implements Runnable {
    private final ChooseClassUiContentProvider m_source;
    private final List<ChooseClassUiContentProvider> m_targets = Lists.newArrayList();

    public MultiTargetRunnable(ChooseClassUiContentProvider source) {
        this.m_source = source;
    }

    public MultiTargetRunnable(ChooseClassUiContentProvider source, ChooseClassUiContentProvider[] targets) {
        this(source);
        ChooseClassUiContentProvider[] chooseClassUiContentProviderArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ChooseClassUiContentProvider target = chooseClassUiContentProviderArray[n2];
            this.addTarget(target, false);
            ++n2;
        }
    }

    public void addTarget(ChooseClassUiContentProvider target, boolean update) {
        this.m_targets.add(target);
        target.getDialogField().setEnabled(false);
        if (update) {
            target.setClassName(this.m_source.getClassName());
        }
    }

    public void removeTarget(ChooseClassUiContentProvider target) {
        this.m_targets.remove(target);
    }

    @Override
    public void run() {
        for (ChooseClassUiContentProvider target : this.m_targets) {
            target.setClassName(this.m_source.getClassName());
        }
    }
}

