/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.wizards.autobindings;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.IAutomaticDatabindingProvider;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wb.internal.core.wizards.TemplateDesignWizardPage;

public abstract class AutomaticDatabindingFirstPage
extends TemplateDesignWizardPage {
    private final IAutomaticDatabindingProvider m_databindingProvider;
    private final String m_initialBeanClassName;

    public AutomaticDatabindingFirstPage(IAutomaticDatabindingProvider databindingProvider, String initialBeanClassName) {
        this.m_databindingProvider = databindingProvider;
        this.m_initialBeanClassName = initialBeanClassName == null ? null : ClassUtils.getShortClassName((String)initialBeanClassName);
    }

    protected void initTypePage(IJavaElement elem) {
        super.initTypePage(elem);
        this.setSuperClass(this.m_databindingProvider.getInitialSuperClass(), false);
        if (this.m_initialBeanClassName != null) {
            this.setTypeName(this.getInitialTypeNameWithSuperClass(), true);
        }
    }

    private String getInitialTypeNameWithSuperClass() {
        return String.valueOf(this.m_initialBeanClassName) + ClassUtils.getShortClassName((String)this.getSuperClass());
    }

    protected void createLocalControls(Composite parent, int columns) {
        Object[] superClasses = this.m_databindingProvider.getSuperClasses();
        int current = ArrayUtils.indexOf((Object[])superClasses, (Object)this.m_databindingProvider.getInitialSuperClass());
        final SelectionButtonDialogFieldGroup fieldsGroup = new SelectionButtonDialogFieldGroup(16, (String[])superClasses, 1);
        fieldsGroup.setLabelText(Messages.AutomaticDatabindingFirstPage_superClassLabel);
        fieldsGroup.setSelection(current, true);
        fieldsGroup.doFillIntoGrid(parent, columns);
        fieldsGroup.setDialogFieldListener(new IDialogFieldListener((String[])superClasses){
            private final /* synthetic */ String[] val$superClasses;
            {
                this.val$superClasses = stringArray;
            }

            public void dialogFieldChanged(DialogField field) {
                int[] selection = fieldsGroup.getSelection();
                if (selection.length == 1) {
                    String superClass = this.val$superClasses[selection[0]];
                    if (AutomaticDatabindingFirstPage.this.m_initialBeanClassName != null && AutomaticDatabindingFirstPage.this.getTypeName().equals(AutomaticDatabindingFirstPage.this.getInitialTypeNameWithSuperClass())) {
                        AutomaticDatabindingFirstPage.this.setTypeName(String.valueOf(AutomaticDatabindingFirstPage.this.m_initialBeanClassName) + ClassUtils.getShortClassName((String)superClass), true);
                    }
                    AutomaticDatabindingFirstPage.this.setSuperClass(superClass, false);
                }
            }
        });
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        InputStream stream = this.m_databindingProvider.getTemplateFile(newType.getSuperclassName());
        try {
            try {
                String code = IOUtils.toString((InputStream)stream);
                code = this.m_databindingProvider.performSubstitutions(code, imports);
                this.fillTypeFromTemplate(newType, imports, monitor, new ByteArrayInputStream(code.getBytes()));
            }
            catch (Throwable e) {
                throw new CoreException((IStatus)DesignerPlugin.createStatus((String)"Error load template file", (Throwable)e));
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

