/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AP1928
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public AP1928(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Message message;
            List extElems;
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            Document root = entryContext.getMessageEntryDocument();
            MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), root);
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if ("request".equals(entryContext.getEntry().getEntryType())) {
                extElems = bindingOperation.getBindingInput() == null ? null : bindingOperation.getBindingInput().getExtensibilityElements();
                message = bindingOperation.getOperation().getInput() == null ? null : bindingOperation.getOperation().getInput().getMessage();
            } else {
                extElems = bindingOperation.getBindingOutput() == null ? null : bindingOperation.getBindingOutput().getExtensibilityElements();
                Message message2 = message = bindingOperation.getOperation().getOutput() == null ? null : bindingOperation.getOperation().getOutput().getMessage();
            }
            if (extElems == null || extElems.size() < 1) {
                throw new AssertionNotApplicableException();
            }
            List swaRefs = this.getSwaRefs((ExtensibilityElement)extElems.get(0), message);
            if (swaRefs.isEmpty()) {
                throw new AssertionNotApplicableException();
            }
            int i = 0;
            while (i < swaRefs.size()) {
                QName elemName = (QName)swaRefs.get(i);
                NodeList elems = root.getDocumentElement().getElementsByTagNameNS(elemName.getNamespaceURI(), elemName.getLocalPart());
                int j = 0;
                while (j < elems.getLength()) {
                    String ref;
                    Node elem = elems.item(j);
                    String string = ref = elem.getFirstChild() == null ? null : elem.getFirstChild().getNodeValue();
                    if (ref == null) {
                        throw new AssertionFailException("The element " + elem.getNodeName() + " of the ref:swaRef schema type is specified, but its vaule" + " is invalid.");
                    }
                    if (!ref.startsWith("cid:")) {
                        throw new AssertionFailException("The URI " + ref + " of the ref:swaRef schema type must use the cid: prefix.");
                    }
                    boolean refFound = false;
                    for (MimePart mimePart : mimeParts.getParts()) {
                        String cid = MIMEUtils.getMimeHeaderAttribute(mimePart.getHeaders(), "Content-ID");
                        if (cid == null || !cid.equals(String.valueOf('<') + ref.substring(4) + '>')) continue;
                        refFound = true;
                        break;
                    }
                    if (!refFound) {
                        throw new AssertionFailException("The SOAP message does not contain a MIME part with the <" + ref.substring(4) + "> Content-ID.");
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private List getSwaRefs(ExtensibilityElement extElem, Message message) {
        ArrayList<QName> swaRefs;
        block17: {
            List mimeParts;
            swaRefs = new ArrayList<QName>();
            if (!extElem.getElementType().equals(WSDL_MIME_MULTIPART) || (mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts()).size() <= 0) break block17;
            List elems = ((MIMEPart)mimeParts.get(0)).getExtensibilityElements();
            ArrayList<Part> boundParts = new ArrayList<Part>();
            int k = 0;
            while (k < elems.size()) {
                ExtensibilityElement elem = (ExtensibilityElement)elems.get(k);
                if (elem.getElementType().equals(WSDL_SOAP_BODY) && message != null) {
                    List bodyParts = ((SOAPBody)elem).getParts();
                    for (Part part : message.getParts().values()) {
                        if (bodyParts != null && !bodyParts.contains(part.getName())) continue;
                        boundParts.add(part);
                    }
                } else if (elem.getElementType().equals(WSDL_SOAP_HEADER)) {
                    Part part;
                    String partName;
                    QName msgName;
                    Object header;
                    if (elem instanceof SOAPHeader) {
                        header = (SOAPHeader)elem;
                        msgName = header.getMessage();
                        partName = header.getPart();
                    } else {
                        String lp;
                        header = ((UnknownExtensibilityElement)elem).getElement();
                        String msgVal = header.getAttribute("message");
                        int colonPos = msgVal.indexOf(":");
                        String ns = null;
                        String string = lp = colonPos > -1 ? msgVal.substring(colonPos + 1) : msgVal;
                        if (colonPos > -1) {
                            ns = this.validator.getWSDLDocument().getDefinitions().getNamespace(msgVal.substring(0, colonPos));
                        }
                        msgName = new QName(ns, lp);
                        partName = header.getAttribute("part");
                    }
                    Message msg = this.validator.getWSDLDocument().getDefinitions().getMessage(msgName);
                    if (msg != null && (part = msg.getPart(partName)) != null) {
                        boundParts.add(part);
                    }
                }
                ++k;
            }
            int i = 0;
            while (i < boundParts.size()) {
                block20: {
                    int type;
                    QName ref;
                    block19: {
                        Part part;
                        block18: {
                            part = (Part)boundParts.get(i);
                            ref = part.getTypeName();
                            if (ref == null) break block18;
                            type = 3;
                            break block19;
                        }
                        ref = part.getElementName();
                        if (ref == null) break block20;
                        type = 2;
                    }
                    Map schemas = this.validator.getWSDLDocument().getSchemas();
                    for (XSModel xsModel : schemas.values()) {
                        XSTypeDefinition xsType = null;
                        if (type == 2) {
                            XSElementDeclaration elem = xsModel.getElementDeclaration(ref.getLocalPart(), ref.getNamespaceURI());
                            if (elem != null && "http://ws-i.org/profiles/basic/1.1/xsd".equals((xsType = elem.getTypeDefinition()).getName()) && "swaRef".equals(xsType.getNamespace())) {
                                swaRefs.add(new QName(elem.getNamespace(), elem.getName()));
                            }
                        } else {
                            xsType = xsModel.getTypeDefinition(ref.getLocalPart(), ref.getNamespaceURI());
                        }
                        swaRefs.addAll(this.collectSwaRefs(xsType));
                    }
                }
                ++i;
            }
        }
        return swaRefs;
    }

    private List collectSwaRefs(XSTypeDefinition xsType) {
        XSComplexTypeDefinition xsComplexType;
        ArrayList swaRefs = new ArrayList();
        if (xsType != null && xsType.getTypeCategory() == 15 && (xsComplexType = (XSComplexTypeDefinition)xsType).getParticle() != null) {
            swaRefs.addAll(this.collectSwaRefs(xsComplexType.getParticle().getTerm()));
        }
        return swaRefs;
    }

    private List collectSwaRefs(XSTerm term) {
        ArrayList<QName> swaRefs = new ArrayList<QName>();
        if (term.getType() == 2) {
            XSElementDeclaration elem = (XSElementDeclaration)term;
            XSTypeDefinition xsType = elem.getTypeDefinition();
            if ("http://ws-i.org/profiles/basic/1.1/xsd".equals(xsType.getNamespace()) && "swaRef".equals(xsType.getName())) {
                swaRefs.add(new QName(elem.getNamespace(), elem.getName()));
            } else {
                swaRefs.addAll(this.collectSwaRefs(xsType));
            }
        } else if (term.getType() == 7) {
            XSObjectList list = ((XSModelGroup)term).getParticles();
            int i = 0;
            while (i < list.getLength()) {
                swaRefs.addAll(this.collectSwaRefs(((XSParticle)list.item(i)).getTerm()));
                ++i;
            }
        }
        return swaRefs;
    }
}

