/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Import;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportHelper {
    public static Definitions getDefinitions(Resource resource) {
        for (EObject eobj : resource.getContents()) {
            if (eobj instanceof Definitions) {
                return (Definitions)eobj;
            }
            if (!(eobj instanceof DocumentRoot)) continue;
            return ((DocumentRoot)eobj).getDefinitions();
        }
        return null;
    }

    public static Import findImportForNamespace(Definitions definitions, String namespace) {
        for (Import imp : definitions.getImports()) {
            if (!namespace.equals(imp.getNamespace())) continue;
            return imp;
        }
        return null;
    }

    public static Import findImportForLocation(Definitions referencingModel, URI location) {
        URI referencingURI = ImportHelper.makeURICanonical(referencingModel.eResource().getURI());
        URI referencedURI = ImportHelper.makeURICanonical(location);
        for (Import imp : referencingModel.getImports()) {
            URI importUri;
            if (imp.getLocation() == null || !(importUri = URI.createURI((String)imp.getLocation()).resolve(referencingURI)).equals(referencedURI)) continue;
            return imp;
        }
        return null;
    }

    public static URI makeURICanonical(URI uri) {
        if (uri.isFile()) {
            File tmpFile = new File(uri.toFileString());
            try {
                return URI.createFileURI((String)tmpFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                return URI.createFileURI((String)tmpFile.getAbsolutePath());
            }
        }
        return uri;
    }
}

