/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dltk.tcl.internal.ui.GlobalVariableEntry;
import org.eclipse.dltk.tcl.internal.ui.TclInterpreterMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class GlobalVariableContentProvider
implements ITreeContentProvider {
    private Viewer fViewer;
    private GlobalVariableEntry[] fVariables = new GlobalVariableEntry[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.fVariables;
    }

    public void setVariables(GlobalVariableEntry[] vars) {
        this.fVariables = vars;
        this.fViewer.refresh();
    }

    public GlobalVariableEntry[] getVariables() {
        GlobalVariableEntry[] variables = new GlobalVariableEntry[this.fVariables.length];
        int i = 0;
        while (i < variables.length) {
            variables[i] = new GlobalVariableEntry(this.fVariables[i]);
            ++i;
        }
        return variables;
    }

    public void remove(Collection<?> selection) {
        ArrayList<GlobalVariableEntry> newVars = new ArrayList<GlobalVariableEntry>();
        int i = 0;
        while (i < this.fVariables.length) {
            newVars.add(this.fVariables[i]);
            ++i;
        }
        for (Object element : selection) {
            if (!(element instanceof GlobalVariableEntry)) continue;
            newVars.remove(element);
        }
        this.fVariables = newVars.toArray(new GlobalVariableEntry[newVars.size()]);
        this.fViewer.refresh();
    }

    public boolean replaceVariable(GlobalVariableEntry variable, GlobalVariableEntry oldVariable) {
        String name = variable.getName();
        ArrayList<GlobalVariableEntry> newVars = new ArrayList<GlobalVariableEntry>();
        newVars.addAll(Arrays.asList(this.fVariables));
        Iterator i = newVars.iterator();
        while (i.hasNext()) {
            GlobalVariableEntry existingVariable = (GlobalVariableEntry)i.next();
            if (!existingVariable.getName().equals(name)) continue;
            boolean overWrite = MessageDialog.openQuestion((Shell)this.fViewer.getControl().getShell(), (String)TclInterpreterMessages.GlobalVariableContentProvider_overwriteTitle, (String)NLS.bind((String)TclInterpreterMessages.GlobalVariableContentProvider_overwriteMessage, (Object)name));
            if (!overWrite) {
                return false;
            }
            i.remove();
            break;
        }
        if (oldVariable != null) {
            newVars.remove(oldVariable);
        }
        newVars.add(variable);
        this.fVariables = newVars.toArray(new GlobalVariableEntry[newVars.size()]);
        return true;
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }
}

