/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.spi.common.CDOLobStoreImpl;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.IOUtil;

public final class CDOBlob
extends CDOLob<InputStream> {
    public CDOBlob(InputStream contents) throws IOException {
        super(contents, CDOLobStoreImpl.INSTANCE);
    }

    public CDOBlob(InputStream contents, CDOLobStore store) throws IOException {
        super(contents, store);
    }

    public CDOBlob(byte[] contents, CDOLobStore store) throws IOException {
        super(new ByteArrayInputStream(contents), store);
    }

    public CDOBlob(String contents, CDOLobStore store) throws IOException {
        super(new ByteArrayInputStream(HexUtil.hexToBytes((String)contents)), store);
    }

    CDOBlob(byte[] id, long size) {
        super(id, size);
    }

    CDOBlob(ExtendedDataInput in) throws IOException {
        super(in);
    }

    @Override
    public File getStoreFile() {
        return this.getStore().getBinaryFile(this.getID());
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.getStore().getBinary(this);
    }

    public byte[] getBytes() throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getContents();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.close((Closeable)inputStream);
        }
    }

    @Override
    public String getString() throws IOException {
        return HexUtil.bytesToHex((byte[])this.getBytes());
    }

    @Override
    protected CDOLobInfo put(InputStream contents) throws IOException {
        return this.getStore().putBinary(contents);
    }
}

