/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreationContext;
import org.eclipse.emf.cdo.common.branch.CDOBranchDoesNotExistException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.branch.CDODuplicateBranchException;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchManagerImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchVersionImpl;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.RemoteException;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CDOBranchImpl
extends Container<CDOBranch>
implements InternalCDOBranch {
    private static final InternalCDOBranch[] NO_BRANCHES = new InternalCDOBranch[0];
    private final InternalCDOBranchManager branchManager;
    private final CDOBranchPoint head = this.getPoint(0L);
    private int id;
    private String name;
    private CDOBranchPoint base;
    private InternalCDOBranch[] branches;
    private boolean deleted;

    public CDOBranchImpl(InternalCDOBranchManager branchManager, int id, String name, CDOBranchPoint base) {
        this.branchManager = branchManager;
        this.id = id;
        this.name = name;
        this.base = base;
        this.activate();
    }

    @Override
    public boolean isMainBranch() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return this.id < 0;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public synchronized void setDeleted() {
        InternalCDOBranch branch;
        if (this.base != null && (branch = (InternalCDOBranch)this.base.getBranch()) != null) {
            branch.removeChild(this);
        }
        this.name = null;
        this.base = null;
        this.branches = null;
        this.deleted = true;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public synchronized String getName() throws CDOBranchDoesNotExistException {
        if (this.name == null) {
            this.load();
        }
        return this.name;
    }

    @Override
    public void setName(String name) throws CDODuplicateBranchException {
        this.checkActive();
        CDOBranchManagerImpl.checkBranchName(name);
        InternalCDOBranchManager.BranchLoader branchLoader = this.branchManager.getBranchLoader();
        if (!(branchLoader instanceof InternalCDOBranchManager.BranchLoader3)) {
            throw new UnsupportedOperationException("Renaming branches is not supported by " + branchLoader);
        }
        String oldName = this.getName();
        if (!ObjectUtil.equals((Object)name, (Object)oldName)) {
            try {
                ((InternalCDOBranchManager.BranchLoader3)branchLoader).renameBranch(this.id, oldName, name);
            }
            catch (RemoteException ex) {
                throw ex.unwrap();
            }
            this.basicSetName(name);
        }
    }

    @Override
    public void basicSetName(String name) {
        this.name = name;
        this.branchManager.handleBranchChanged(this, CDOBranchChangedEvent.ChangeKind.RENAMED, this.id);
    }

    @Override
    public CDOBranch getBranch() {
        return this.deleted ? null : this.base.getBranch();
    }

    @Override
    public long getTimeStamp() {
        return this.deleted ? -1L : this.base.getTimeStamp();
    }

    @Override
    public boolean isProxy() {
        return this.name == null || this.base == null;
    }

    @Override
    public String getPathName() {
        if (this.deleted) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        this.computePathName(this, builder);
        return builder.toString();
    }

    private void computePathName(CDOBranch branch, StringBuilder builder) {
        CDOBranchPoint base = branch.getBase();
        CDOBranch parent = base.getBranch();
        if (parent != null) {
            this.computePathName(parent, builder);
            builder.append("/");
        }
        builder.append(branch.getName());
    }

    @Override
    public CDOBranchPoint[] getBasePath() {
        ArrayList<CDOBranchPoint> path = new ArrayList<CDOBranchPoint>();
        this.computeBasePath(this, path);
        return path.toArray(new CDOBranchPoint[path.size()]);
    }

    private void computeBasePath(CDOBranch branch, List<CDOBranchPoint> path) {
        CDOBranchPoint base = branch.getBase();
        CDOBranch parent = base.getBranch();
        if (parent != null) {
            this.computeBasePath(parent, path);
        }
        path.add(base);
    }

    @Override
    public synchronized CDOBranchPoint getBase() throws CDOBranchDoesNotExistException {
        if (this.base == null) {
            this.load();
        }
        return this.base;
    }

    @Override
    public CDOBranchPoint getHead() {
        return this.head;
    }

    @Override
    public CDOBranchPoint getPoint(long timeStamp) {
        return new CDOBranchPointImpl(this, timeStamp);
    }

    @Override
    public CDOBranchVersion getVersion(int version) {
        return new CDOBranchVersionImpl(this, version);
    }

    @Override
    public InternalCDOBranch createBranch(String name, long timeStamp) throws CDODuplicateBranchException {
        return this.branchManager.createBranch(Integer.MAX_VALUE, name, this, timeStamp);
    }

    @Override
    public InternalCDOBranch createBranch(String name) throws CDODuplicateBranchException {
        return this.createBranch(name, 0L);
    }

    @Override
    public CDOBranch[] delete(OMMonitor monitor) {
        this.checkActive();
        if (monitor == null) {
            monitor = new Monitor();
        }
        return this.branchManager.deleteBranches(this.id, monitor);
    }

    @Override
    public void fireDeletedEvent() {
        this.fireEvent(new BranchDeletedEventImpl(this));
    }

    public InternalCDOBranch[] getElements() {
        return this.getBranches();
    }

    @Override
    public InternalCDOBranch[] getBranches(boolean loadOnDemand) {
        if (!this.branchManager.getRepository().isSupportingBranches()) {
            return NO_BRANCHES;
        }
        if (this.branches == null && loadOnDemand) {
            this.loadBranches();
        }
        return this.branches;
    }

    @Override
    public synchronized InternalCDOBranch[] getBranches() {
        return this.getBranches(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public InternalCDOBranch getBranch(String path) {
        if (this.branchManager.getRepository().isSupportingBranches()) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            path = path.substring(1);
lbl4:
            // 2 sources

            ** while (path.startsWith((String)"/"))
        }
lbl5:
        // 2 sources

        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - "/".length());
        }
        sep = path.indexOf("/");
        if (sep == -1) {
            return this.getChild(path);
        }
        name = path.substring(0, sep);
        child = this.getChild(name);
        if (child == null) {
            return null;
        }
        rest = path.substring(sep + 1);
        return child.getBranch(rest);
    }

    @Override
    @Deprecated
    public void rename(String newName) {
        this.setName(newName);
    }

    private InternalCDOBranch getChild(String name) {
        InternalCDOBranch[] branches;
        InternalCDOBranch[] internalCDOBranchArray = branches = this.getBranches();
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOBranch branch = internalCDOBranchArray[n2];
            if (name.equals(branch.getName())) {
                return branch;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public InternalCDOBranchManager.BranchLoader.BranchInfo getBranchInfo() {
        CDOBranchPoint base = this.getBase();
        return new InternalCDOBranchManager.BranchLoader.BranchInfo(this.getName(), base.getBranch().getID(), base.getTimeStamp());
    }

    @Override
    public void setBranchInfo(String name, InternalCDOBranch baseBranch, long baseTimeStamp) {
        this.name = name;
        this.base = baseBranch.getPoint(baseTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(InternalCDOBranch branch) {
        CDOBranchImpl cDOBranchImpl = this;
        synchronized (cDOBranchImpl) {
            if (this.branches == null) {
                this.loadBranches();
            } else {
                InternalCDOBranch[] newBranches = new InternalCDOBranch[this.branches.length + 1];
                System.arraycopy(this.branches, 0, newBranches, 0, this.branches.length);
                newBranches[this.branches.length] = branch;
                this.branches = newBranches;
            }
        }
        this.fireElementAddedEvent(branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(InternalCDOBranch branch) {
        boolean changed = true;
        CDOBranchImpl cDOBranchImpl = this;
        synchronized (cDOBranchImpl) {
            if (this.branches == null) {
                this.loadBranches();
            } else {
                ArrayList<InternalCDOBranch> list = new ArrayList<InternalCDOBranch>(Arrays.asList(this.branches));
                if (list.remove(branch)) {
                    this.branches = list.toArray(new InternalCDOBranch[list.size()]);
                } else {
                    changed = false;
                }
            }
        }
        if (changed) {
            this.fireElementRemovedEvent(branch);
        }
    }

    public Object getAdapter(Class adapter) {
        CDOCommonRepository repository;
        if (adapter == CDOBranchCreationContext.class && (repository = this.branchManager.getRepository()).isSupportingBranches()) {
            return new CDOBranchCreationContext(){

                @Override
                public CDOBranchPoint getBase() {
                    return CDOBranchImpl.this.getHead();
                }
            };
        }
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    @Override
    public int compareTo(CDOBranch o) {
        int otherID = o.getID();
        return this.id < otherID ? -1 : (this.id == otherID ? 0 : 1);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        if (this.isProxy()) {
            if (this.deleted) {
                return MessageFormat.format("Branch[id={0}, DELETED]", this.id);
            }
            return MessageFormat.format("Branch[id={0}, PROXY]", this.id);
        }
        return MessageFormat.format("Branch[id={0}, name={1}]", this.id, this.name);
    }

    private synchronized void load() throws CDOBranchDoesNotExistException {
        if (this.deleted) {
            return;
        }
        InternalCDOBranchManager.BranchLoader branchLoader = this.branchManager.getBranchLoader();
        InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = branchLoader.loadBranch(this.id);
        if (branchInfo == null) {
            throw new CDOBranchDoesNotExistException(this.id);
        }
        int baseBranchID = branchInfo.getBaseBranchID();
        InternalCDOBranch baseBranch = this.branchManager.getBranch(baseBranchID);
        this.name = branchInfo.getName();
        this.base = baseBranch.getPoint(branchInfo.getBaseTimeStamp());
    }

    private synchronized void loadBranches() {
        if (this.deleted) {
            return;
        }
        InternalCDOBranchManager.BranchLoader.SubBranchInfo[] infos = this.branchManager.getBranchLoader().loadSubBranches(this.id);
        this.branches = new InternalCDOBranch[infos.length];
        int i = 0;
        while (i < infos.length) {
            InternalCDOBranchManager.BranchLoader.SubBranchInfo info = infos[i];
            this.branches[i] = this.branchManager.getBranch(info.getID(), info.getName(), this, info.getBaseTimeStamp());
            ++i;
        }
    }

    private static final class BranchDeletedEventImpl
    extends Event
    implements CDOBranch.BranchDeletedEvent {
        private static final long serialVersionUID = 1L;

        public BranchDeletedEventImpl(CDOBranch branch) {
            super((INotifier)branch);
        }

        @Override
        public CDOBranch getSource() {
            return (CDOBranch)super.getSource();
        }

        @Override
        public CDOBranch getBranch() {
            return this.getSource();
        }
    }

    public static class Main
    extends CDOBranchImpl {
        private boolean local;

        public Main(InternalCDOBranchManager branchManager, boolean local, long timeStamp) {
            super(branchManager, 0, "MAIN", new CDOBranchPointImpl(null, timeStamp));
            this.local = local;
        }

        @Override
        public boolean isMainBranch() {
            return true;
        }

        @Override
        public boolean isLocal() {
            return this.local;
        }

        @Override
        public void setName(String name) {
            throw new IllegalArgumentException("Renaming the MAIN branch is not supported");
        }

        @Override
        public CDOBranch[] delete(OMMonitor monitor) {
            throw new IllegalArgumentException("Deleting the MAIN branch is not supported");
        }
    }
}

