/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    protected static List<String> parseName(String sourceName, char sourceSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        int length = sourceName.length();
        boolean lastIsLower = false;
        int index = 0;
        while (index < length) {
            char curChar = sourceName.charAt(index);
            if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == sourceSeparator) {
                if (lastIsLower || curChar == sourceSeparator) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                lastIsLower = false;
            } else {
                int currentWordLength;
                if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                    char lastChar = currentWord.charAt(--currentWordLength);
                    currentWord.setLength(currentWordLength);
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                    currentWord.append(lastChar);
                }
                lastIsLower = true;
            }
            if (curChar != sourceSeparator) {
                currentWord.append(curChar);
            }
            ++index;
        }
        result.add(currentWord.toString());
        return result;
    }

    protected static String format(String name, char separator) {
        StringBuffer result = new StringBuffer();
        Iterator<String> i = StringUtil.parseName(name, '_').iterator();
        while (i.hasNext()) {
            String component = i.next();
            result.append(component);
            if (!i.hasNext() || component.length() <= 1) continue;
            result.append(separator);
        }
        return result.toString();
    }

    protected static String capName(String name) {
        return name.length() == 0 ? name : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    protected static EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }

    public static String getText(Object object) {
        if (object instanceof Collection) {
            StringBuilder sb = new StringBuilder("[");
            Iterator i = ((Collection)object).iterator();
            while (i.hasNext()) {
                sb.append(StringUtil.getText(i.next()));
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(']');
            return sb.toString();
        }
        if (object instanceof EObject) {
            Object value;
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            String label = StringUtil.format(StringUtil.capName(eClass.getName()), ' ');
            EStructuralFeature feature = StringUtil.getLabelFeature(eClass);
            if (feature != null && (value = eObject.eGet(feature)) != null) {
                return String.valueOf(label) + " " + value.toString();
            }
            return label;
        }
        return String.valueOf(object);
    }

    public static String getFeatureText(EStructuralFeature feature) {
        return StringUtil.format(StringUtil.capName(feature.getName()), ' ');
    }

    public static String getTypeText(EClassifier classifier) {
        return String.valueOf(classifier.getEPackage().getName()) + '.' + classifier.getName();
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().length() < 1;
    }
}

