/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ChangeContentsOperation
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Change Contents";
    private IViewer viewer;
    private List<? extends Object> newContents;
    private List<? extends Object> initialContents;

    public ChangeContentsOperation(IViewer viewer) {
        this(DEFAULT_LABEL, viewer, new ArrayList<Object>((Collection<Object>)viewer.getContents()));
    }

    public ChangeContentsOperation(IViewer viewer, List<? extends Object> contents) {
        this(DEFAULT_LABEL, viewer, contents);
    }

    public ChangeContentsOperation(String label, IViewer viewer, List<? extends Object> contents) {
        super(label);
        this.viewer = viewer;
        this.newContents = new ArrayList<Object>(contents);
        this.initialContents = new ArrayList<Object>((Collection<Object>)viewer.getContents());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.viewer.getContents().equals(this.newContents)) {
            this.viewer.getContents().setAll(this.newContents);
        }
        return Status.OK_STATUS;
    }

    protected List<? extends Object> getInitialContents() {
        return this.initialContents;
    }

    protected List<? extends Object> getNewContents() {
        return this.newContents;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialContents == this.newContents || this.initialContents != null && this.initialContents.equals(this.newContents);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setNewContents(List<? extends Object> newContents) {
        this.newContents = new ArrayList<Object>(newContents);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.viewer.getContents().setAll(this.initialContents);
        return Status.OK_STATUS;
    }
}

