/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.DependencyDepth;
import org.eclipse.m2e.pde.target.DomXmlFeature;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetDependencyFilter;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.target.MavenTargetRepository;
import org.eclipse.m2e.pde.target.MissingMetadataMode;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenTargetLocationFactory
implements ITargetLocationFactory {
    private static final String ATTRIBUTE_DEPENDENCY_SCOPE = "includeDependencyScope";

    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
            Element location = document.getDocumentElement();
            try {
                mode = MissingMetadataMode.valueOf(location.getAttribute("missingManifest").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                mode = MissingMetadataMode.ERROR;
            }
            String dependencyScope = location.getAttribute(ATTRIBUTE_DEPENDENCY_SCOPE);
            ArrayList<MavenTargetDependency> dependencies = new ArrayList<MavenTargetDependency>();
            ArrayList<MavenTargetRepository> repositories = new ArrayList<MavenTargetRepository>();
            NodeList dependencyNodeList = location.getElementsByTagName("dependency");
            int dependencyLength = dependencyNodeList.getLength();
            if (dependencyLength == 0) {
                dependencies.add(this.parseDependency(location));
            } else {
                int i = 0;
                while (i < dependencyLength) {
                    Node item = dependencyNodeList.item(i);
                    if (item instanceof Element var14_18) {
                        dependencies.add(this.parseDependency((Element)element));
                    }
                    ++i;
                }
            }
            NodeList repositoryNodeList = location.getElementsByTagName("repository");
            int repositoryLength = repositoryNodeList.getLength();
            int i = 0;
            while (i < repositoryLength) {
                Node item = repositoryNodeList.item(i);
                Node node = item;
                if (node instanceof Element && (var16_21 = (Element)node) == (Element)node) {
                    repositories.add(new MavenTargetRepository(this.getText("id", (Element)element), this.getText("url", (Element)element)));
                }
                ++i;
            }
            NodeList instructionsNodeList = location.getElementsByTagName("instructions");
            NodeList excludesNodeList = location.getElementsByTagName("exclude");
            ArrayList<BNDInstructions> instructions = new ArrayList<BNDInstructions>();
            ArrayList<String> excludes = new ArrayList<String>();
            int instructionsLength = instructionsNodeList.getLength();
            int i2 = 0;
            while (i2 < instructionsLength) {
                Node item = instructionsNodeList.item(i2);
                if (item instanceof Element var21_30) {
                    instructions.add(new BNDInstructions(instructionElement.getAttribute("reference"), instructionElement.getTextContent()));
                }
                ++i2;
            }
            int excludesLength = excludesNodeList.getLength();
            int i3 = 0;
            while (i3 < excludesLength) {
                Node item = excludesNodeList.item(i3);
                if (item instanceof Element var22_32) {
                    excludes.add(element.getTextContent());
                }
                ++i3;
            }
            NodeList featuresNodeList = location.getElementsByTagName("feature");
            IFeature templateFeature = IntStream.range(0, featuresNodeList.getLength()).mapToObj(featuresNodeList::item).map(DomXmlFeature::new).findFirst().orElse(null);
            if (location.hasAttribute("includeDependencyDepth")) {
                try {
                    dependencyDepth = DependencyDepth.valueOf(location.getAttribute("includeDependencyDepth").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    dependencyDepth = DependencyDepth.NONE;
                }
            } else {
                dependencyDepth = dependencyScope.isEmpty() ? DependencyDepth.NONE : DependencyDepth.INFINITE;
            }
            LinkedHashSet<String> locationScopesSet = new LinkedHashSet<String>();
            if (location.hasAttribute("includeDependencyScopes")) {
                String dependencyScopes = location.getAttribute("includeDependencyScopes");
                String[] stringArray = dependencyScopes.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String scope = stringArray[n2];
                    locationScopesSet.add(scope.strip().toLowerCase());
                    ++n2;
                }
            } else {
                locationScopesSet.addAll(MavenTargetDependencyFilter.expandScope(dependencyScope));
            }
            return new MavenTargetLocation(location.getAttribute("label"), dependencies, repositories, mode, dependencyDepth, locationScopesSet, Boolean.parseBoolean(location.getAttribute("includeSource")), instructions, excludes, templateFeature);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    private MavenTargetDependency parseDependency(Element element) {
        String artifactId = this.getText("artifactId", element);
        String groupId = this.getText("groupId", element);
        String version = this.getText("version", element);
        String artifactType = this.getText("type", element);
        String classifier = this.getText("classifier", element);
        return new MavenTargetDependency(groupId, artifactId, version, artifactType, classifier);
    }

    private String getText(String tagName, Element location) {
        NodeList nodeList = location.getElementsByTagName(tagName);
        int i = 0;
        while (i < nodeList.getLength()) {
            String textContent = nodeList.item(i).getTextContent();
            if (textContent != null) {
                return textContent;
            }
            ++i;
        }
        return "";
    }
}

