/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import aQute.bnd.version.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.m2e.pde.target.MavenSourceBundle;
import org.eclipse.m2e.pde.target.MavenTargetBundle;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;

class TargetBundles {
    private final Map<Artifact, TargetBundle> bundles = new HashMap<Artifact, TargetBundle>();
    private final Map<File, Artifact> artifacts = new HashMap<File, Artifact>();
    private final Map<Artifact, MavenSourceBundle> sourceBundles = new HashMap<Artifact, MavenSourceBundle>();
    final Set<Artifact> ignoredArtifacts = new HashSet<Artifact>();
    final List<TargetFeature> features = new ArrayList<TargetFeature>();
    final Map<MavenTargetDependency, List<DependencyNode>> dependencyNodes = new HashMap<MavenTargetDependency, List<DependencyNode>>();

    TargetBundles() {
    }

    Optional<DependencyNode> getDependencyNode(Artifact artifact) {
        return this.dependencyNodes.values().stream().flatMap(l -> l.stream()).filter(node -> artifact.equals(node.getArtifact())).findAny();
    }

    Optional<MavenTargetBundle> getMavenTargetBundle(Artifact artifact) {
        return Optional.ofNullable(this.bundles.get(artifact)).filter(MavenTargetBundle.class::isInstance).map(MavenTargetBundle.class::cast);
    }

    Optional<TargetBundle> getTargetBundle(Artifact artifact, boolean source) {
        if (source) {
            return Optional.ofNullable((TargetBundle)this.sourceBundles.get(artifact));
        }
        return Optional.ofNullable(this.bundles.get(artifact));
    }

    Optional<MavenTargetBundle> getTargetBundle(MavenTargetDependency dependency) {
        List<DependencyNode> list = this.dependencyNodes.get((Object)dependency);
        if (list != null) {
            Optional<Artifact> artifact = list.stream().filter(node -> node.getData().get("dependencynode.root") == dependency).findFirst().map(DependencyNode::getArtifact);
            return artifact.flatMap(this::getMavenTargetBundle);
        }
        return Optional.empty();
    }

    public static Version createOSGiVersion(Artifact artifact) {
        String version = artifact.getVersion();
        return TargetBundles.createOSGiVersion(version);
    }

    public static Version createOSGiVersion(Model model) {
        return TargetBundles.createOSGiVersion(model.getVersion());
    }

    public static Version createOSGiVersion(String version) {
        if (version == null || version.isEmpty()) {
            return new Version(0, 0, 1);
        }
        try {
            int index = version.indexOf(45);
            if (index > -1) {
                StringBuilder sb = new StringBuilder(version);
                sb.setCharAt(index, '.');
                return Version.parseVersion((String)sb.toString());
            }
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            return new Version(0, 0, 1, version);
        }
    }

    public void addBundle(Artifact artifact, TargetBundle bundle) {
        this.bundles.put(artifact, bundle);
        File file = artifact.getFile();
        if (file != null) {
            this.artifacts.put(file, artifact);
        }
    }

    public void addSourceBundle(Artifact artifact, MavenSourceBundle sourceBundle) {
        this.sourceBundles.put(artifact, sourceBundle);
    }

    public Stream<Map.Entry<Artifact, TargetBundle>> bundles() {
        return this.bundles.entrySet().stream();
    }

    public Optional<Artifact> getArtifact(File file) {
        return Optional.ofNullable(this.artifacts.get(file));
    }
}

