/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.editors.MetaclassViewer;
import org.eclipse.modisco.infra.browser.editors.table.TableEditorInput;
import org.eclipse.modisco.infra.browser.editors.table.TableElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MetaclassViewerMenuManager
extends MenuManager
implements IMenuListener {
    private final BrowserConfiguration browserConfiguration;
    private final MetaclassViewer metaclassViewer;
    private final IAction openTableEditorAction = new Action(Messages.openTableEditorOnSelection){

        public void run() {
            EClass[] selectedMetaclasses = MetaclassViewerMenuManager.this.metaclassViewer.getSelectedMetaclasses();
            ArrayList<TableElement> elements = new ArrayList<TableElement>();
            EClass[] eClassArray = selectedMetaclasses;
            int n = selectedMetaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                EClass selectedMetaclass = eClassArray[n2];
                InstancesForMetaclass instancesForMetaclass = MetaclassViewerMenuManager.this.browserConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass(selectedMetaclass);
                if (instancesForMetaclass != null) {
                    ArrayList<EObject> instances = instancesForMetaclass.getElements();
                    for (EObject eObject : instances) {
                        elements.add(new TableElement(eObject));
                    }
                    if (MetaclassViewerMenuManager.this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses()) {
                        ArrayList<EObject> derivedElements = instancesForMetaclass.getDerivedElements();
                        for (EObject eObject : derivedElements) {
                            elements.add(new TableElement(eObject));
                        }
                    }
                }
                ++n2;
            }
            String[] selectedMetaclassesNames = MetaclassViewerMenuManager.this.metaclassViewer.getSelectedMetaclassesQualifiedNames();
            TableEditorInput tableEditorInput = new TableEditorInput(MetaclassViewerMenuManager.this.browserConfiguration, elements, this.getDescriptionFor(selectedMetaclassesNames));
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)tableEditorInput, (String)"org.eclipse.modisco.infra.browser.table.editorID", (boolean)true);
            }
            catch (PartInitException e) {
                MoDiscoBrowserPlugin.logException(e);
            }
        }

        private String getDescriptionFor(String[] selectedMetaclasses) {
            if (selectedMetaclasses.length < 1) {
                throw new IllegalArgumentException();
            }
            StringBuilder description = new StringBuilder();
            description.append(Messages.MetaclassViewerMenuManager_instancesOf);
            description.append(selectedMetaclasses[0]);
            int i = 1;
            while (i < selectedMetaclasses.length) {
                description.append(", " + selectedMetaclasses[i]);
                ++i;
            }
            return description.toString();
        }
    };

    public MetaclassViewerMenuManager(MetaclassViewer metaclassViewer, BrowserConfiguration browserConfiguration) {
        super("#PopUp");
        this.metaclassViewer = metaclassViewer;
        this.browserConfiguration = browserConfiguration;
        this.addMenuActions();
        this.addMenuListener(this);
    }

    private void addMenuActions() {
        this.add(this.openTableEditorAction);
        this.add((IContributionItem)new Separator("additions"));
    }

    public void menuAboutToShow(IMenuManager manager) {
        EClass[] selectedMetaclasses = this.metaclassViewer.getSelectedMetaclasses();
        this.openTableEditorAction.setEnabled(selectedMetaclasses.length > 0);
    }
}

