/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.ui.databinding;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.infra.tools.databinding.MultipleObservableValue;

public class AggregatedPapyrusObservableValue
extends MultipleObservableValue {
    private final List<CommandBasedObservableValue> observables = new LinkedList<CommandBasedObservableValue>();
    private final EditingDomain domain;

    public AggregatedPapyrusObservableValue(EditingDomain domain, IObservable ... observableValues) {
        this.domain = domain;
        IObservable[] iObservableArray = observableValues;
        int n = observableValues.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable value = iObservableArray[n2];
            if (this.aggregate(value) == null) {
                throw new IllegalArgumentException("The input ObservableValues have an incorrect type");
            }
            ++n2;
        }
    }

    public AggregatedObservable aggregate(IObservable observable) {
        if (observable instanceof CommandBasedObservableValue) {
            if (!this.observables.isEmpty()) {
                Object valueType = this.observables.get(0).getValueType();
                if (((IObservableValue)observable).getValueType() != valueType) {
                    return null;
                }
            }
            this.observables.add((CommandBasedObservableValue)observable);
            super.aggregate(observable);
            return this;
        }
        return null;
    }

    public void doSetValue(Object value) {
        CompoundCommand command = new CompoundCommand();
        for (CommandBasedObservableValue observableValue : this.observables) {
            command.append(observableValue.getCommand(value));
        }
        this.domain.getCommandStack().execute((Command)command);
    }
}

