/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.command.ObjectFlowReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.tools.utils.ActivityEdgeUtil;
import org.eclipse.papyrus.uml.tools.utils.ObjectFlowUtil;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.UMLPackage;

public class ObjectFlowEditHelper
extends ElementEditHelper {
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        ICommand updatePartitionsCommand;
        ActivityNode target;
        ObjectFlowReorientCommand resultCommand = new ObjectFlowReorientCommand(req);
        ObjectFlow objectFlow = (ObjectFlow)req.getRelationship();
        boolean isReorientSource = req.getDirection() == 1;
        EObject source = isReorientSource ? req.getNewRelationshipEnd() : objectFlow.getSource();
        Object object = target = isReorientSource ? objectFlow.getTarget() : req.getNewRelationshipEnd();
        if ((source == null || source instanceof ActivityNode) && (target == null || target instanceof ActivityNode) && (updatePartitionsCommand = this.getInPartitionUpdateCommand(objectFlow, (ActivityNode)source, target)) != null) {
            resultCommand = CompositeCommand.compose((ICommand)resultCommand, (ICommand)updatePartitionsCommand);
        }
        return resultCommand;
    }

    protected boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        return this.canCreate(source, target);
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            if (source != null && !(source instanceof ActivityNode)) {
                return UnexecutableCommand.INSTANCE;
            }
            return IdentityCommand.INSTANCE;
        }
        Element proposedContainer = this.deduceContainer(req);
        if (proposedContainer == null) {
            return UnexecutableCommand.INSTANCE;
        }
        req.setContainer((EObject)proposedContainer);
        return new CreateRelationshipCommand(req);
    }

    protected Element deduceContainer(CreateRelationshipRequest request) {
        return ActivityEdgeUtil.deduceContainer((EObject)request.getSource(), (EObject)request.getTarget());
    }

    @Override
    protected ICommand getConfigureCommand(final ConfigureRequest req) {
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                ObjectFlow element = (ObjectFlow)req.getElementToConfigure();
                ActivityNode source = ObjectFlowEditHelper.this.getSourceObject(req);
                ActivityNode target = ObjectFlowEditHelper.this.getTargetObject(req);
                if (source != null) {
                    element.setSource(ObjectFlowEditHelper.this.getSourceObject(req));
                }
                if (target != null) {
                    element.setTarget(target);
                }
                if (source != null && target != null) {
                    ArrayList partitions = new ArrayList(source.getInPartitions());
                    partitions.retainAll((Collection<?>)target.getInPartitions());
                    element.getInPartitions().addAll(partitions);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    protected ActivityNode getSourceObject(ConfigureRequest req) {
        Object result = req.getParameter("CreateRelationshipRequest.source");
        return result instanceof ActivityNode ? (ActivityNode)result : null;
    }

    protected ActivityNode getTargetObject(ConfigureRequest req) {
        Object result = req.getParameter("CreateRelationshipRequest.target");
        return result instanceof ActivityNode ? (ActivityNode)result : null;
    }

    protected boolean canCreate(EObject source, EObject target) {
        if (source != null && !(source instanceof ActivityNode)) {
            return false;
        }
        if (target != null && !(target instanceof ActivityNode)) {
            return false;
        }
        Element container = ActivityEdgeUtil.deduceContainer((EObject)source, (EObject)target);
        if (container == null) {
            return false;
        }
        return ObjectFlowUtil.canExistObjectFlow((Element)container, null, (ActivityNode)((ActivityNode)source), (ActivityNode)((ActivityNode)target));
    }

    protected ICommand getInPartitionUpdateCommand(ObjectFlow objectFlow, ActivityNode source, ActivityNode target) {
        ArrayList partitions = new ArrayList();
        if (source != null && target != null) {
            partitions = new ArrayList(source.getInPartitions());
            partitions.retainAll((Collection<?>)target.getInPartitions());
            if (!partitions.isEmpty()) {
                return new SetValueCommand(new SetRequest((EObject)objectFlow, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityEdge_InPartition(), partitions));
            }
        }
        if (partitions.isEmpty() && !objectFlow.getInPartitions().isEmpty()) {
            return new SetValueCommand(new SetRequest((EObject)objectFlow, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityEdge_InPartition(), partitions));
        }
        return null;
    }
}

