/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.ISystemCommandTextAdditionalGUIProvider;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.SystemCommandTextField;
import org.eclipse.rse.internal.useractions.ui.SystemCommandViewerConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDAEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDSelectTypeListener;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDSelectTypesForm;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeViewNewItem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.internal.useractions.ui.validators.ValidatorUserActionComment;
import org.eclipse.rse.internal.useractions.ui.validators.ValidatorUserActionName;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.view.ISystemCommandTextModifyListener;
import org.eclipse.rse.ui.ISystemMassager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;
import org.eclipse.rse.ui.widgets.SystemEditPaneStateMachine;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemUDActionEditPane
implements SelectionListener,
ISelectionChangedListener,
Listener,
ISystemUDSelectTypeListener,
ISystemCommandTextAdditionalGUIProvider,
ISystemCommandTextModifyListener,
MouseListener,
KeyListener {
    protected Text textName;
    protected Text textComment;
    protected SystemCommandTextField commandField;
    protected Button promptCB;
    protected Button refreshCB;
    protected Button showCB;
    protected Button singleSelCB;
    protected Button collectCB;
    protected Button resetButton;
    protected Label typesSeparator;
    protected SystemUDSelectTypesForm selectTypesForm;
    protected boolean menuListenerAdded;
    protected String testActionName;
    protected SystemMessage errorMessage;
    protected ISubSystem subsystem;
    protected SystemUDActionSubsystem udaActionSubsys;
    protected ISubSystemConfiguration subsystemFactory;
    protected ISystemProfile profile;
    public SystemUDActionElement currentAction;
    protected ISystemValidator nameValidator;
    protected ISystemValidator cmtValidator;
    private boolean isEnabled = false;
    private boolean recursiveCall = false;
    private boolean ignoreChanges = false;
    private NameModifyListener nameML = new NameModifyListener();
    private NameFocusListener nameFL = new NameFocusListener();
    private CommentModifyListener commentML = new CommentModifyListener();
    protected ISystemUDAEditPaneHoster parentDialog;
    protected ISystemUDTreeView treeView;
    private boolean nameChanged = false;
    protected boolean newMode = false;
    private int newModeDomain = -1;
    private SystemUDTreeViewNewItem newModeNewItem;
    private Vector EMPTY_VECTOR = new Vector();
    private boolean grabFocus = true;
    private SystemEditPaneStateMachine stateMachine;

    public SystemUDActionEditPane(SystemUDActionSubsystem udaActionSubsys, ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        this.udaActionSubsys = udaActionSubsys;
        this.subsystem = udaActionSubsys.getSubsystem();
        this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
        this.profile = this.profile == null ? this.subsystem.getSystemProfile() : this.profile;
        this.parentDialog = parent;
        this.treeView = tv;
        this.commandField = new SystemCommandTextField(this.getCommandTextViewerConfiguration());
        this.testActionName = this.getUDActionSubsystem().getTestActionName().toLowerCase();
    }

    protected SystemUDActionSubsystem getUDActionSubsystem() {
        return this.udaActionSubsys;
    }

    protected SystemCommandViewerConfiguration getCommandTextViewerConfiguration() {
        return new SystemCommandViewerConfiguration();
    }

    protected void setCommandTextViewerConfiguration(SystemCommandViewerConfiguration cmdAssistant) {
        this.commandField.setCommandTextViewerConfiguration(cmdAssistant);
    }

    protected ISubSystem getSubSystem() {
        return this.subsystem;
    }

    protected ISystemProfile getProfile() {
        return this.profile;
    }

    protected Shell getShell() {
        return this.parentDialog.getShell();
    }

    public void setStateMachine(SystemEditPaneStateMachine sm) {
        this.stateMachine = sm;
    }

    public void setNameValidator(ISystemValidator validator) {
        this.nameValidator = validator;
    }

    public void setCommentValidator(ISystemValidator validator) {
        this.cmtValidator = validator;
    }

    public void setCommandValidator(ISystemValidator validator) {
        this.commandField.setCommandValidator(validator);
    }

    public void setCommandMassager(ISystemMassager massager) {
        this.commandField.setCommandMassager(massager);
    }

    public void setSubstitutionVariableList(SystemCmdSubstVarList varList) {
        this.commandField.setSubstitutionVariableList(varList);
    }

    public Control createContents(Composite parent) {
        if (this.nameValidator == null) {
            this.nameValidator = new ValidatorUserActionName();
        }
        if (this.cmtValidator == null) {
            this.cmtValidator = new ValidatorUserActionComment();
        }
        int nbrColumns = 3;
        Composite comp = SystemWidgetHelpers.createComposite((Composite)parent, (int)3);
        this.textName = SystemWidgetHelpers.createLabeledTextField((Composite)comp, null, (String)SystemUDAResources.RESID_UDA_NAME_LABEL, (String)SystemUDAResources.RESID_UDA_NAME_TOOLTIP);
        ((GridData)this.textName.getLayoutData()).horizontalSpan = 2;
        this.textComment = SystemWidgetHelpers.createLabeledTextField((Composite)comp, null, (String)SystemUDAResources.RESID_UDA_COMMENT_LABEL, (String)SystemUDAResources.RESID_UDA_COMMENT_TOOLTIP);
        ((GridData)this.textComment.getLayoutData()).horizontalSpan = 2;
        this.commandField.setMRI(SystemUDAResources.RESID_UDA_COMMAND_LABEL, SystemUDAResources.RESID_UDA_COMMAND_TOOLTIP, SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_LABEL, SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_TOOLTIP);
        this.commandField.createContents(comp, 3, this);
        this.addFillerLine(comp, 3);
        Composite options_composite = SystemWidgetHelpers.createTightComposite((Composite)comp, (int)3);
        ((GridData)options_composite.getLayoutData()).horizontalSpan = 3;
        this.promptCB = SystemWidgetHelpers.createCheckBox((Composite)options_composite, (int)1, null, (String)SystemUDAResources.RESID_UDA_OPTION_PROMPT_LABEL, (String)SystemUDAResources.RESID_UDA_OPTION_PROMPT_TOOLTIP);
        this.refreshCB = SystemWidgetHelpers.createCheckBox((Composite)options_composite, (int)1, null, (String)SystemUDAResources.RESID_UDA_OPTION_REFRESH_LABEL, (String)SystemUDAResources.RESID_UDA_OPTION_REFRESH_TOOLTIP);
        this.showCB = SystemWidgetHelpers.createCheckBox((Composite)options_composite, (int)1, null, (String)SystemUDAResources.RESID_UDA_OPTION_SHOW_LABEL, (String)SystemUDAResources.RESID_UDA_OPTION_SHOW_TOOLTIP);
        this.singleSelCB = SystemWidgetHelpers.createCheckBox((Composite)options_composite, (int)1, null, (String)SystemUDAResources.RESID_UDA_OPTION_SINGLESEL_LABEL, (String)SystemUDAResources.RESID_UDA_OPTION_SINGLESEL_TOOLTIP);
        this.collectCB = SystemWidgetHelpers.createCheckBox((Composite)options_composite, (int)1, null, (String)this.getInvokeOnceLabel(), (String)this.getInvokeOnceTooltip());
        Control[] extraOptions = this.createExtraOptionCheckBoxes(options_composite);
        if (this.getUDActionSubsystem().supportsTypes()) {
            this.addFillerLine(comp, 3);
        }
        if (this.udaActionSubsys != null) {
            this.selectTypesForm = this.createSelectTypesForm(this.parentDialog.getShell(), this.subsystem, this.udaActionSubsys);
        }
        if (this.selectTypesForm != null) {
            this.selectTypesForm.createContents(comp, 3);
        }
        this.textName.setTextLimit(256);
        this.textComment.setTextLimit(256);
        this.promptCB.addSelectionListener((SelectionListener)this);
        this.refreshCB.addSelectionListener((SelectionListener)this);
        this.showCB.addSelectionListener((SelectionListener)this);
        this.singleSelCB.addSelectionListener((SelectionListener)this);
        this.collectCB.addSelectionListener((SelectionListener)this);
        if (extraOptions != null) {
            int idx = 0;
            while (idx < extraOptions.length) {
                if (extraOptions[idx] instanceof Button) {
                    ((Button)extraOptions[idx]).addSelectionListener((SelectionListener)this);
                } else if (extraOptions[idx] instanceof Combo) {
                    ((Combo)extraOptions[idx]).addSelectionListener((SelectionListener)this);
                } else if (extraOptions[idx] instanceof List) {
                    ((List)extraOptions[idx]).addSelectionListener((SelectionListener)this);
                }
                ++idx;
            }
        }
        if (this.selectTypesForm != null) {
            this.selectTypesForm.addSelectionListener(this);
        }
        this.textName.addModifyListener((ModifyListener)this.nameML);
        this.textName.addFocusListener((FocusListener)this.nameFL);
        this.textComment.addModifyListener((ModifyListener)this.commentML);
        this.commandField.addModifyListener(this);
        return comp;
    }

    protected String getInvokeOnceLabel() {
        return SystemUDAResources.RESID_UDA_OPTION_COLLECT_LABEL;
    }

    protected String getInvokeOnceTooltip() {
        return SystemUDAResources.RESID_UDA_OPTION_COLLECT_TOOLTIP;
    }

    public boolean areErrorsPending() {
        return this.errorMessage != null && (this.currentAction != null || this.newMode);
    }

    public void selectionChanged(SelectionChangedEvent se) {
        if (this.recursiveCall) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)se.getSelection();
        Object so = ss.getFirstElement();
        if (this.areErrorsPending() && (this.newMode || SystemUDBaseManager.inCurrentTree(this.currentAction.getElement()))) {
            if (!this.newMode && so != this.currentAction) {
                this.treeView.setSelection((ISelection)new StructuredSelection((Object)this.currentAction));
            } else if (this.newMode && so != this.newModeNewItem) {
                this.treeView.setSelection((ISelection)new StructuredSelection((Object)this.newModeNewItem));
            }
            return;
        }
        if (this.stateMachine != null && this.stateMachine.isSaveRequired()) {
            this.saveData();
            if (this.newMode) {
                this.recursiveCall = true;
                this.treeView.refreshElementParent(this.currentAction);
                this.recursiveCall = false;
                if (so instanceof SystemUDActionElement) {
                    this.treeView.selectElement((SystemUDActionElement)so);
                } else if (so != null) {
                    this.treeView.setSelection((ISelection)new StructuredSelection(so));
                }
                return;
            }
        }
        this.recursiveCall = false;
        this.errorMessage = null;
        this.resetPageValidation();
        boolean bl = this.newMode = so instanceof SystemUDTreeViewNewItem && ((SystemUDTreeViewNewItem)so).isExecutable();
        if (this.newMode) {
            this.newModeDomain = ((SystemUDTreeViewNewItem)so).getDomain();
        }
        if (this.nameChanged) {
            this.nameChanged = false;
            if (this.currentAction != null) {
                this.treeView.refresh(this.currentAction);
            }
        }
        SystemUDActionElement sn = null;
        if (so != null && so instanceof SystemUDActionElement) {
            sn = (SystemUDActionElement)so;
        }
        this.currentAction = sn;
        this.setIgnoreChanges(true);
        boolean changeMode = false;
        if (!this.newMode && (sn == null || sn.isDomain())) {
            this.isEnabled = false;
            this.textName.setText("");
            this.textComment.setText("");
            this.setCommandText("");
            this.enableExtraButtons(false);
        } else if (this.newMode) {
            this.isEnabled = true;
            SystemCmdSubstVarList varList = null;
            this.textName.setText("");
            this.textComment.setText("");
            this.setCommandText("");
            this.promptCB.setSelection(false);
            this.refreshCB.setSelection(false);
            this.showCB.setSelection(true);
            this.singleSelCB.setSelection(false);
            this.collectCB.setSelection(false);
            this.resetExtraOptionsForNewMode();
            if (so != null) {
                varList = this.getActionSubstVarList(((SystemUDTreeViewNewItem)so).getDomain());
            }
            this.commandField.setSubstitutionVariableList(varList);
            this.enableExtraButtons(true);
        } else {
            this.isEnabled = true;
            changeMode = true;
            this.setAction(sn);
        }
        this.setIgnoreChanges(false);
        if (this.newMode) {
            this.stateMachine.setNewMode();
            this.newModeNewItem = (SystemUDTreeViewNewItem)so;
        } else if (sn == null || sn.isDomain()) {
            this.stateMachine.setUnsetMode();
        } else {
            this.stateMachine.setEditMode();
        }
        if (this.isEnabled && this.typesSeparator != null) {
            int domain = this.getDomain();
            if (domain == -1) {
                this.typesSeparator.setVisible(this.getUDActionSubsystem().supportsTypes());
            } else {
                this.typesSeparator.setVisible(this.getUDActionSubsystem().supportsTypes(domain));
            }
        }
        if (!changeMode && this.selectTypesForm != null) {
            this.reConfigureSelectTypesForm(this.selectTypesForm);
        }
        if (this.isEnabled && this.newMode) {
            if (this.grabFocus) {
                this.textName.setFocus();
            }
            if (this.nameValidator instanceof ISystemValidatorUniqueString) {
                ((ISystemValidatorUniqueString)this.nameValidator).setExistingNamesList((Collection)this.getExistingActionNames());
            }
        }
        this.setPageComplete();
    }

    public void setAction(SystemUDActionElement action) {
        this.currentAction = action;
        boolean currentIgnoreState = this.ignoreChanges;
        this.setIgnoreChanges(true);
        this.textName.setText(action.toString());
        this.textComment.setText(action.getComment());
        this.setCommandText(action.getCommand());
        this.promptCB.setSelection(action.getPrompt());
        this.refreshCB.setSelection(action.getRefresh());
        this.showCB.setSelection(action.getShow());
        this.singleSelCB.setSelection(action.getSingleSelection());
        this.collectCB.setSelection(action.getCollect());
        this.collectCB.setEnabled(!this.singleSelCB.getSelection());
        this.resetExtraOptions(action);
        this.commandField.setSubstitutionVariableList(this.getActionSubstVarList(action.getDomain()));
        this.setIgnoreChanges(currentIgnoreState);
        if (this.selectTypesForm != null) {
            this.reConfigureSelectTypesForm(this.selectTypesForm);
        }
        if (this.grabFocus) {
            this.textName.setFocus();
        }
        if (this.nameValidator instanceof ISystemValidatorUniqueString) {
            ((ISystemValidatorUniqueString)this.nameValidator).setExistingNamesList((Collection)this.getExistingActionNames());
        }
        this.enableExtraButtons(true);
    }

    public void mouseDown(MouseEvent e) {
        this.grabFocus = true;
    }

    public void mouseUp(MouseEvent e) {
        this.grabFocus = true;
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.grabFocus = true;
    }

    public void keyPressed(KeyEvent e) {
        this.grabFocus = false;
    }

    public void keyReleased(KeyEvent e) {
        this.grabFocus = false;
    }

    protected int getDomain() {
        if (this.newMode) {
            return this.newModeDomain;
        }
        if (this.currentAction != null) {
            return this.currentAction.getDomain();
        }
        return -1;
    }

    public void revertPressed() {
        if (this.currentAction != null && !this.currentAction.isDomain()) {
            this.textName.setText(this.currentAction.toString());
            this.setCommandText(this.currentAction.getCommand());
            this.textComment.setText(this.currentAction.getComment());
            this.promptCB.setSelection(this.currentAction.getPrompt());
            this.refreshCB.setSelection(this.currentAction.getRefresh());
            this.showCB.setSelection(this.currentAction.getShow());
            this.singleSelCB.setSelection(this.currentAction.getSingleSelection());
            this.collectCB.setSelection(this.currentAction.getCollect());
            this.collectCB.setEnabled(!this.singleSelCB.getSelection());
            this.resetExtraOptions(this.currentAction);
            if (this.selectTypesForm != null) {
                this.selectTypesForm.setTypes(this.currentAction.getFileTypes());
            }
            if (this.stateMachine != null) {
                this.stateMachine.resetPressed();
            }
        } else if (this.newMode) {
            this.resetPageValidation();
            this.setIgnoreChanges(true);
            this.textName.setText("");
            this.setCommandText("");
            this.textComment.setText("");
            this.promptCB.setSelection(false);
            this.refreshCB.setSelection(false);
            this.showCB.setSelection(true);
            this.singleSelCB.setSelection(false);
            this.collectCB.setSelection(false);
            this.collectCB.setEnabled(true);
            this.resetExtraOptionsForNewMode();
            if (this.selectTypesForm != null) {
                this.selectTypesForm.resetTypes();
            }
            this.setIgnoreChanges(false);
            if (this.stateMachine != null) {
                this.stateMachine.resetPressed();
            }
        }
        this.resetPageValidation();
    }

    public void applyPressed() {
        if ((this.newMode || this.currentAction != null && !this.currentAction.isDomain()) && this.validateInput(true, null)) {
            this.saveData();
            if (this.stateMachine != null) {
                this.stateMachine.applyPressed();
            }
            if (this.newMode) {
                this.recursiveCall = true;
                this.treeView.refreshElementParent(this.currentAction);
                this.recursiveCall = false;
                this.treeView.selectElement(this.currentAction);
            } else {
                this.treeView.refresh(this.currentAction);
            }
        }
        this.setPageComplete();
    }

    public boolean createCommandLabelLineControls(Composite parent, int availableColumns) {
        return false;
    }

    public boolean createExtraButtons(Composite parent, int availableColumns) {
        return false;
    }

    protected SystemUDSelectTypesForm createSelectTypesForm(Shell shell, ISubSystem subsystem, SystemUDActionSubsystem udaActionSubsys) {
        if (udaActionSubsys.supportsTypes()) {
            return new SystemUDSelectTypesForm(shell, subsystem, udaActionSubsys.getUDTypeManager());
        }
        return null;
    }

    protected void reConfigureSelectTypesForm(SystemUDSelectTypesForm form) {
        SystemUDActionSubsystem udas = this.getUDActionSubsystem();
        SystemUDTypeManager udtm = udas.getUDTypeManager();
        if (this.currentAction != null) {
            int domainType = this.currentAction.getDomain();
            if (domainType != -1 && !udas.supportsTypes(domainType)) {
                form.setVisible(false);
            } else {
                form.setVisible(true);
                form.setMasterTypes(udtm.getTypeNames(this.currentAction.getDomain()));
                form.setTypes(this.currentAction.getFileTypes());
                form.setDomain(domainType);
            }
        } else if (this.newMode) {
            if (this.newModeDomain != -1 && !udas.supportsTypes(this.newModeDomain)) {
                form.setVisible(false);
            } else {
                form.setVisible(true);
                form.setMasterTypes(udtm.getTypeNames(this.newModeDomain));
                form.resetTypes();
                form.setDomain(this.newModeDomain);
            }
        } else {
            form.reset();
        }
    }

    protected SystemCmdSubstVarList getActionSubstVarList(int actionDomainType) {
        SystemCmdSubstVarList varList = this.getUDActionSubsystem().getActionSubstVarList(actionDomainType);
        return varList;
    }

    protected Control[] createExtraOptionCheckBoxes(Composite parent) {
        return null;
    }

    protected void enableExtraButtons(boolean b) {
    }

    protected void processExtraOptionsChanges(SystemUDActionElement currentAction) {
    }

    protected void resetExtraOptions(SystemUDActionElement originalAction) {
    }

    protected void resetExtraOptionsForNewMode() {
    }

    public void handleEvent(Event arg0) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.newMode && this.currentAction == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this.singleSelCB) {
            if (this.singleSelCB.getSelection()) {
                this.collectCB.setSelection(false);
                this.collectCB.setEnabled(false);
            } else {
                this.collectCB.setEnabled(true);
            }
        }
        if (source instanceof Button || source instanceof Combo) {
            this.validateInput(false, null);
        }
        this.setChangesMade();
        this.setPageComplete();
    }

    public void selectedTypeListChanged(SystemUDSelectTypesForm form) {
        this.setChangesMade();
        this.setPageComplete();
        this.validateInput(false, null);
    }

    public void masterTypeListChanged(SystemUDSelectTypesForm form) {
        SystemUDActionSubsystem udas = this.getUDActionSubsystem();
        SystemUDTypeManager udtm = udas.getUDTypeManager();
        if (this.currentAction != null) {
            form.setMasterTypes(udtm.getTypeNames(this.currentAction.getDomain()));
        } else if (this.newMode) {
            form.setMasterTypes(udtm.getTypeNames(this.newModeDomain));
        }
    }

    private void resetPageValidation() {
        this.errorMessage = null;
        this.parentDialog.clearErrorMessage();
        this.parentDialog.setPageComplete(true);
    }

    protected final boolean validateInput(boolean setFocus, Control skipControl) {
        Text errCtl = null;
        this.errorMessage = null;
        if (skipControl != this.textName) {
            this.errorMessage = this.validateName(this.textName.getText().trim());
        }
        errCtl = this.textName;
        if (this.errorMessage == null && skipControl != this.textComment) {
            this.errorMessage = this.validateComment(this.textComment.getText().trim());
            errCtl = this.textComment;
        }
        if (this.errorMessage == null && skipControl != this.getCommandWidget()) {
            this.errorMessage = this.validateCommand();
            errCtl = this.getCommandWidget();
        }
        if (this.errorMessage == null) {
            this.errorMessage = this.doAdditionalValidation(setFocus);
        }
        if (this.errorMessage != null) {
            this.parentDialog.setErrorMessage(this.errorMessage);
            if (setFocus) {
                errCtl.setFocus();
            }
        } else {
            this.parentDialog.clearErrorMessage();
        }
        this.setPageComplete();
        return this.errorMessage == null;
    }

    protected SystemMessage doAdditionalValidation(boolean doSetFocus) {
        return null;
    }

    protected SystemMessage validateName(String input) {
        return this.nameValidator.validate(input);
    }

    protected SystemMessage validateComment(String input) {
        return this.cmtValidator.validate(input);
    }

    protected SystemMessage validateCommand() {
        return this.commandField.validateCommand();
    }

    protected Control getCommandWidget() {
        return this.commandField.getCommandWidget();
    }

    protected void setCommandText(String text) {
        this.commandField.setCommandText(text);
    }

    protected void enableCommandWidget(boolean enable) {
        this.commandField.enableCommandWidget(enable);
    }

    protected String getCommandText() {
        return this.commandField.getCommandText();
    }

    protected void setIgnoreChanges(boolean ignore) {
        this.ignoreChanges = ignore;
        this.commandField.setIgnoreChanges(ignore);
    }

    protected boolean isPageComplete() {
        return this.errorMessage == null && this.textName.getText().trim().length() > 0 && this.getCommandText().length() > 0;
    }

    protected void setPageComplete() {
        boolean complete = this.isPageComplete();
        this.parentDialog.setPageComplete(complete);
    }

    protected void processChanges() {
        this.currentAction.setComment(this.textComment.getText().trim());
        this.currentAction.setName(this.textName.getText().trim());
        String cmd = this.commandField.getMassagedCommandText();
        if (this.commandField.getCommandMassager() != null && !this.newMode) {
            this.setIgnoreChanges(true);
            this.setCommandText(cmd);
            this.setIgnoreChanges(false);
        }
        this.currentAction.setCommand(cmd);
        this.currentAction.setPrompt(this.promptCB.getSelection());
        this.currentAction.setRefresh(this.refreshCB.getSelection());
        this.currentAction.setShow(this.showCB.getSelection());
        this.currentAction.setSingleSelection(this.singleSelCB.getSelection());
        this.currentAction.setCollect(this.collectCB.getSelection());
        this.processExtraOptionsChanges(this.currentAction);
        if (this.selectTypesForm != null) {
            this.currentAction.setFileTypes(this.selectTypesForm.getTypes());
        }
    }

    protected void saveData() {
        if (this.newMode) {
            this.currentAction = this.createNewAction(this.textName.getText().trim(), this.newModeDomain);
        }
        this.processChanges();
        SystemUDActionSubsystem udas = this.getUDActionSubsystem();
        SystemUDActionManager udam = udas.getUDActionManager();
        ISystemProfile currentProfile = udam.getCurrentProfile();
        if (currentProfile == null) {
            currentProfile = this.profile;
        }
        udam.saveUserData(currentProfile);
        if (this.newMode) {
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 128, (Object)this.currentAction, null);
        } else {
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 128, (Object)this.currentAction, null);
        }
    }

    protected void setChangesMade() {
        if (this.stateMachine != null) {
            this.stateMachine.setChangesMade();
        }
    }

    protected SystemUDActionElement createNewAction(String actionName, int domain) {
        SystemUDActionElement na;
        SystemUDActionSubsystem udas = this.getUDActionSubsystem();
        SystemUDActionManager udam = udas.getUDActionManager();
        ISystemProfile currentProfile = udam.getCurrentProfile();
        if (currentProfile == null) {
            currentProfile = this.profile;
        }
        if ((na = udam.addAction(currentProfile, actionName, domain)) != null && domain != -1) {
            SystemUDTypeManager typeManager = this.getUDActionSubsystem().getUDTypeManager();
            if (typeManager.findChildByName(currentProfile, "ALL", domain) == null) {
                SystemUDTypeElement nt = typeManager.addType(domain, "ALL");
                nt.setTypes("*");
                typeManager.saveUserData(currentProfile);
            }
            String[] types = new String[]{"ALL"};
            na.setFileTypes(types);
        }
        return na;
    }

    protected Vector getExistingActionNames() {
        if (this.newMode) {
            SystemUDActionSubsystem udas = this.getUDActionSubsystem();
            SystemUDActionManager udam = udas.getUDActionManager();
            ISystemProfile currentProfile = udam.getCurrentProfile();
            if (currentProfile == null) {
                currentProfile = this.profile;
            }
            return udam.getExistingNames(currentProfile, this.newModeDomain);
        }
        if (this.currentAction != null) {
            return this.currentAction.getExistingNames();
        }
        return this.EMPTY_VECTOR;
    }

    public void commandModified(String cmdText, SystemMessage errorMessage) {
        this.errorMessage = errorMessage;
        this.setChangesMade();
        if (errorMessage != null) {
            this.parentDialog.setErrorMessage(errorMessage);
            this.setPageComplete();
        } else {
            this.validateInput(false, this.getCommandWidget());
        }
        this.processCommandTextChange(cmdText, errorMessage != null);
    }

    protected void processCommandTextChange(String newText, boolean hasError) {
    }

    protected Label addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Label addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
        return filler;
    }

    private class CommentModifyListener
    implements ModifyListener {
        private CommentModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (SystemUDActionEditPane.this.ignoreChanges) {
                return;
            }
            SystemUDActionEditPane.this.setChangesMade();
            SystemUDActionEditPane.this.errorMessage = SystemUDActionEditPane.this.validateComment(SystemUDActionEditPane.this.textComment.getText().trim());
            if (SystemUDActionEditPane.this.errorMessage != null) {
                SystemUDActionEditPane.this.parentDialog.setErrorMessage(SystemUDActionEditPane.this.errorMessage);
                SystemUDActionEditPane.this.setPageComplete();
            } else {
                SystemUDActionEditPane.this.validateInput(false, (Control)SystemUDActionEditPane.this.textComment);
            }
        }
    }

    private class NameFocusListener
    implements FocusListener {
        private NameFocusListener() {
        }

        public void focusLost(FocusEvent event) {
            if (SystemUDActionEditPane.this.ignoreChanges) {
                return;
            }
            String name = SystemUDActionEditPane.this.textName.getText().trim().toLowerCase();
            if (name.startsWith(SystemUDActionEditPane.this.testActionName) && SystemUDActionEditPane.this.textComment.getText().trim().length() == 0 && SystemUDActionEditPane.this.getCommandText().length() == 0) {
                SystemUDActionEditPane.this.textComment.setText(SystemUDActionEditPane.this.getUDActionSubsystem().getTestFilePath());
                SystemUDActionEditPane.this.setCommandText(SystemUDActionEditPane.this.getUDActionSubsystem().getTestFileName());
            }
        }

        public void focusGained(FocusEvent event) {
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (SystemUDActionEditPane.this.ignoreChanges) {
                return;
            }
            SystemUDActionEditPane.this.setChangesMade();
            SystemUDActionEditPane.this.errorMessage = SystemUDActionEditPane.this.validateName(SystemUDActionEditPane.this.textName.getText().trim());
            if (SystemUDActionEditPane.this.errorMessage != null) {
                SystemUDActionEditPane.this.parentDialog.setErrorMessage(SystemUDActionEditPane.this.errorMessage);
                SystemUDActionEditPane.this.setPageComplete();
            } else {
                SystemUDActionEditPane.this.validateInput(false, (Control)SystemUDActionEditPane.this.textName);
                SystemUDActionEditPane.this.nameChanged = true;
            }
        }
    }
}

