/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.common.core.process.ProcessUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst28EventLayout;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class UstDebugInfoStateProvider
extends AbstractTmfStateProvider {
    public static final String MEMSZ_ATTRIB = "memsz";
    public static final String PATH_ATTRIB = "path";
    public static final String IS_PIC_ATTRIB = "is_pic";
    public static final String BUILD_ID_ATTRIB = "build_id";
    public static final String DEBUG_LINK_ATTRIB = "debug_link";
    public static final String FUNCTION_NAME = "functionName";
    public static final String SOURCE_FILE_NAME = "sourceFileName";
    public static final String LINE_NUMBER = "lineNr";
    private static final int VERSION = 5;
    private static final Logger LOGGER = TraceCompassLog.getLogger(UstDebugInfoStateProvider.class);
    private static final int DL_DLOPEN_INDEX = 1;
    private static final int DL_BUILD_ID_INDEX = 2;
    private static final int DL_DEBUG_LINK_INDEX = 3;
    private static final int DL_DLCLOSE_INDEX = 4;
    private static final int STATEDUMP_BIN_INFO_INDEX = 5;
    private static final int STATEDUMP_BUILD_ID_INDEX = 6;
    private static final int STATEDUMP_DEBUG_LINK_INDEX = 7;
    private static final int STATEDUMP_START_INDEX = 8;
    private static final String NM_EXECUTABLE = "nm";
    private static final Pattern fNmPattern = Pattern.compile("(\\w+)(\\s+)(\\w)(\\s+)([^\\t]*)([\\t]*)([^\\:]*)([\\:]*)(.*)");
    private final LttngUst28EventLayout fLayout;
    private final Map<String, Integer> fEventNames;
    private final Map<Integer, Long> fLatestStatedumpStarts = new HashMap<Integer, Long>();
    private final Map<Pair<Long, Long>, PendingBinInfo> fPendingBinInfos = new HashMap<Pair<Long, Long>, PendingBinInfo>();

    public UstDebugInfoStateProvider(LttngUstTrace trace) {
        super((ITmfTrace)trace, "Ust:DebugInfo");
        ILttngUstEventLayout layout = trace.getEventLayout();
        if (!(layout instanceof LttngUst28EventLayout)) {
            throw new IllegalStateException("Debug info analysis was started with an incompatible trace.");
        }
        this.fLayout = (LttngUst28EventLayout)layout;
        this.fEventNames = UstDebugInfoStateProvider.buildEventNames(this.fLayout);
    }

    private static Map<String, Integer> buildEventNames(LttngUst28EventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventDlOpen(), (Object)1);
        builder.put((Object)layout.eventDlBuildId(), (Object)2);
        builder.put((Object)layout.eventDlDebugLink(), (Object)3);
        builder.put((Object)layout.eventDlClose(), (Object)4);
        builder.put((Object)layout.eventStatedumpBinInfo(), (Object)5);
        builder.put((Object)layout.eventStateDumpBuildId(), (Object)6);
        builder.put((Object)layout.eventStateDumpDebugLink(), (Object)7);
        builder.put((Object)layout.eventStatedumpStart(), (Object)8);
        return builder.build();
    }

    protected void eventHandle(ITmfEvent event) {
        String name = event.getName();
        Integer index = this.fEventNames.get(name);
        if (index == null) {
            return;
        }
        Integer vpid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
        if (vpid == null) {
            return;
        }
        @NonNull ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        int intIndex = index;
        switch (intIndex) {
            case 8: {
                this.handleStatedumpStart(event, vpid, ss);
                break;
            }
            case 5: {
                this.handleBinInfo(event, vpid, ss, true);
                break;
            }
            case 1: {
                this.handleBinInfo(event, vpid, ss, false);
                break;
            }
            case 6: {
                this.handleBuildId(event, vpid, ss, true);
                break;
            }
            case 2: {
                this.handleBuildId(event, vpid, ss, false);
                break;
            }
            case 7: {
                this.handleDebugLink(event, vpid, ss, true);
                break;
            }
            case 3: {
                this.handleDebugLink(event, vpid, ss, false);
                break;
            }
            case 4: {
                this.handleClose(event, vpid, ss);
                break;
            }
        }
    }

    private static void commitPendingToStateSystem(PendingBinInfo pending, long ts, ITmfStateSystemBuilder ss) {
        if (!pending.done()) {
            throw new IllegalStateException();
        }
        long vpid = pending.fVpid;
        long baddr = pending.fBaddr;
        long memsz = pending.fMemsz;
        String path = pending.fPath;
        String buildId = pending.getBuildId();
        String debugLink = pending.getDebugLink();
        boolean isPIC = pending.fIsPIC;
        int baddrQuark = ss.getQuarkAbsoluteAndAdd(new String[]{Long.toString(vpid), Long.toString(baddr)});
        int memszQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{MEMSZ_ATTRIB});
        int pathQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{PATH_ATTRIB});
        int isPICQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{IS_PIC_ATTRIB});
        int buildIdQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{BUILD_ID_ATTRIB});
        int debugLinkQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{DEBUG_LINK_ATTRIB});
        try {
            ss.modifyAttribute(ts, (Object)1, baddrQuark);
            ss.modifyAttribute(ts, (Object)memsz, memszQuark);
            ss.modifyAttribute(ts, (Object)path, pathQuark);
            ss.modifyAttribute(ts, (Object)(isPIC ? 1 : 0), isPICQuark);
            if (buildId != null) {
                ss.modifyAttribute(ts, (Object)buildId, buildIdQuark);
            } else {
                ss.modifyAttribute(ts, null, buildIdQuark);
            }
            if (debugLink != null) {
                ss.modifyAttribute(ts, (Object)debugLink, debugLinkQuark);
            } else {
                ss.modifyAttribute(ts, null, debugLinkQuark);
            }
        }
        catch (StateValueTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    private @Nullable PendingBinInfo retrievePendingBinInfo(long vpid, long baddr) {
        Pair key = new Pair((Object)vpid, (Object)baddr);
        return this.fPendingBinInfos.remove(key);
    }

    private void processPendingBinInfo(PendingBinInfo pending, long ts, ITmfStateSystemBuilder ss) {
        if (pending.done()) {
            UstDebugInfoStateProvider.commitPendingToStateSystem(pending, ts, ss);
        } else {
            Pair key = new Pair((Object)pending.fVpid, (Object)pending.fBaddr);
            this.fPendingBinInfos.put((Pair<Long, Long>)key, pending);
        }
    }

    private void handleStatedumpStart(ITmfEvent event, Integer vpid, ITmfStateSystemBuilder ss) {
        long ts = event.getTimestamp().getValue();
        this.fLatestStatedumpStarts.put(vpid, ts);
        try {
            int vpidQuark = ss.getQuarkAbsolute(new String[]{vpid.toString()});
            ss.removeAttribute(ts, vpidQuark);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    private void handleBinInfo(ITmfEvent event, Integer vpid, ITmfStateSystemBuilder ss, boolean statedump) {
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        Long memsz = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldMemsz()});
        String path = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldPath()});
        Long hasBuildIdValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldHasBuildId()});
        Long hasDebugLinkValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldHasDebugLink()});
        Long isPicValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldIsPic()});
        if (baddr == null || memsz == null || path == null || hasBuildIdValue == null || hasDebugLinkValue == null || statedump && isPicValue == null) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"UstDebugInfoStateProvider:InvalidBinInfoEvent", (Object[])new Object[]{"event", event});
            return;
        }
        boolean isPic = statedump ? (Long)NonNullUtils.checkNotNull((Object)isPicValue) != 0L : true;
        long ts = this.getBinInfoTimeStamp(event, vpid, statedump);
        boolean hasBuildId = hasBuildIdValue != 0L;
        boolean hasDebugLink = hasDebugLinkValue != 0L;
        PendingBinInfo p = new PendingBinInfo(hasBuildId, hasDebugLink, vpid.intValue(), baddr, memsz, path, isPic);
        this.processPendingBinInfo(p, ts, ss);
    }

    private void handleBuildId(ITmfEvent event, Integer vpid, ITmfStateSystemBuilder ss, boolean statedump) {
        long[] buildIdArray = (long[])event.getContent().getFieldValue(long[].class, new String[]{this.fLayout.fieldBuildId()});
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        if (buildIdArray == null || baddr == null) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"UstDebugInfoStateProvider:InvalidBinIdEvent", (Object[])new Object[]{"event", event});
            return;
        }
        String buildId = (String)NonNullUtils.checkNotNull((Object)BaseEncoding.base16().encode(UstDebugInfoStateProvider.longArrayToByteArray(buildIdArray)).toLowerCase());
        long ts = this.getBinInfoTimeStamp(event, vpid, statedump);
        PendingBinInfo p = this.retrievePendingBinInfo(vpid.intValue(), baddr);
        if (p == null) {
            return;
        }
        p.setBuildId(buildId);
        this.processPendingBinInfo(p, ts, ss);
    }

    private void handleDebugLink(ITmfEvent event, Integer vpid, ITmfStateSystemBuilder ss, boolean statedump) {
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        String debugLink = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldDebugLinkFilename()});
        if (baddr == null || debugLink == null) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"UstDebugInfoStateProvider:InvalidDebugLinkEvent", (Object[])new Object[]{"event", event});
            return;
        }
        long ts = this.getBinInfoTimeStamp(event, vpid, statedump);
        PendingBinInfo pendingBinInfo = this.retrievePendingBinInfo(vpid.intValue(), baddr);
        if (pendingBinInfo == null) {
            return;
        }
        pendingBinInfo.setDebugLink(debugLink);
        this.processPendingBinInfo(pendingBinInfo, ts, ss);
    }

    private void handleClose(ITmfEvent event, Integer vpid, ITmfStateSystemBuilder ss) {
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        if (baddr == null) {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.CONFIG, (String)"UstDebugInfoStateProvider:InvalidDlCloseEvent", (Object[])new Object[]{"event", event});
            return;
        }
        try {
            int quark = ss.getQuarkAbsolute(new String[]{vpid.toString(), baddr.toString()});
            long ts = event.getTimestamp().getValue();
            ss.removeAttribute(ts, quark);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    private long getBinInfoTimeStamp(ITmfEvent event, Integer vpid, boolean statedump) {
        Long statedumpStartTime;
        if (statedump && (statedumpStartTime = this.fLatestStatedumpStarts.get(vpid)) != null) {
            return statedumpStartTime;
        }
        return event.getTimestamp().getValue();
    }

    private static byte[] longArrayToByteArray(long[] array) {
        byte[] ret = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            ret[i] = (byte)array[i];
            ++i;
        }
        return ret;
    }

    public ITmfStateProvider getNewInstance() {
        return new UstDebugInfoStateProvider(this.getTrace());
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public int getVersion() {
        return 5;
    }

    public void done() {
        HashSet<String> binPaths = new HashSet<String>();
        @NonNull ITmfStateSystemBuilder ssb = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        List vPidQuarks = ssb.getQuarks(new String[]{"*"});
        Iterator iterator = vPidQuarks.iterator();
        while (iterator.hasNext()) {
            int vPidQuark = (Integer)iterator.next();
            List bAddrQuarks = ssb.getQuarks(vPidQuark, new String[]{"*"});
            Iterator iterator2 = bAddrQuarks.iterator();
            while (iterator2.hasNext()) {
                int bAddrQuark = (Integer)iterator2.next();
                try {
                    Integer pathQuark = ssb.getQuarkRelative(bAddrQuark, new String[]{PATH_ATTRIB});
                    List states = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ssb, (int)pathQuark, (long)ssb.getStartTime(), (long)ssb.getCurrentEndTime());
                    for (ITmfStateInterval state : states) {
                        String binPath = state.getValueString();
                        if (binPath == null) continue;
                        binPaths.add(binPath);
                    }
                }
                catch (AttributeNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
        }
        for (String binPath : binPaths) {
            UstDebugInfoStateProvider.getNmInfo(ssb, binPath);
        }
        super.done();
    }

    private static Iterable<String> callNm(String filePath) {
        List<String> command = Arrays.asList(NM_EXECUTABLE, "-l", "-C", filePath);
        List output = ProcessUtils.getOutputFromCommand(command);
        if (output != null) {
            Collections.sort(output);
            return output;
        }
        return Collections.emptySet();
    }

    private static void getNmInfo(ITmfStateSystemBuilder ssb, String binFilePath) {
        Iterable<String> sortedNmResults = UstDebugInfoStateProvider.callNm(binFilePath);
        if (Iterables.size(sortedNmResults) > 0) {
            for (String nmLine : sortedNmResults) {
                Matcher nmLineMatcher = fNmPattern.matcher(nmLine);
                if (!nmLineMatcher.matches()) continue;
                String offset = nmLineMatcher.group(1).replaceFirst("^0+(?!$)", "");
                String functionName = nmLineMatcher.group(5);
                if (offset == null || functionName == null) continue;
                String sourceFile = nmLineMatcher.group(7);
                String lineNr = nmLineMatcher.group(9);
                int funNameQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{binFilePath, FUNCTION_NAME});
                int sourceFileQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{binFilePath, SOURCE_FILE_NAME});
                int lineNrQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{binFilePath, LINE_NUMBER});
                try {
                    Long offsetLong = Long.parseLong(offset, 16) + ssb.getStartTime();
                    ssb.modifyAttribute(offsetLong.longValue(), (Object)functionName, funNameQuark);
                    ssb.modifyAttribute(offsetLong.longValue(), (Object)sourceFile, sourceFileQuark);
                    ssb.modifyAttribute(offsetLong.longValue(), (Object)lineNr, lineNrQuark);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private static class PendingBinInfo {
        private final long fVpid;
        private final long fBaddr;
        private final long fMemsz;
        private final String fPath;
        private final boolean fIsPIC;
        private @Nullable String fBuildId = null;
        private @Nullable String fDebugLink = null;
        private boolean fBuildIdPending;
        private boolean fDebugLinkPending;

        public PendingBinInfo(boolean hasBuildId, boolean hasDebugLink, long vpid, long baddr, long memsz, String path, boolean isPIC) {
            this.fVpid = vpid;
            this.fBaddr = baddr;
            this.fMemsz = memsz;
            this.fPath = path;
            this.fIsPIC = isPIC;
            this.fBuildIdPending = hasBuildId;
            this.fDebugLinkPending = hasDebugLink;
        }

        boolean done() {
            return !this.fBuildIdPending && !this.fDebugLinkPending;
        }

        public void setBuildId(String buildId) {
            this.fBuildIdPending = false;
            this.fBuildId = buildId;
        }

        public @Nullable String getBuildId() {
            return this.fBuildId;
        }

        public void setDebugLink(String debugLink) {
            this.fDebugLinkPending = false;
            this.fDebugLink = debugLink;
        }

        public @Nullable String getDebugLink() {
            return this.fDebugLink;
        }
    }
}

