/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.util;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.EngineError;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pair;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class ViatraQueryEngineLabelProvider extends LabelProvider {
  private final ImageRegistry imageRegistry = EMFPatternLanguageUIPlugin.getInstance().getImageRegistry();
  
  private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
  
  public ViatraQueryEngineLabelProvider() {
    final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    AdapterFactoryLabelProvider _adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    this.adapterFactoryLabelProvider = _adapterFactoryLabelProvider;
  }
  
  @Override
  public Image getImage(final Object element) {
    return this.getImageInternal(element);
  }
  
  protected Image _getImageInternal(final ViatraQueryEngine element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_VIATRA);
  }
  
  protected Image _getImageInternal(final BaseIndexOptions element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_BASE_OPTIONS);
  }
  
  protected Image _getImageInternal(final ViatraQueryEngineOptions element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_ENGINE_OPTIONS);
  }
  
  protected Image _getImageInternal(final IQueryBackendFactory element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_VQL);
  }
  
  protected Image _getImageInternal(final QueryEvaluationHint element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_VQL);
  }
  
  protected Image _getImageInternal(final EngineError element) {
    return this.imageRegistry.get(EMFPatternLanguageUIPlugin.ICON_ERROR);
  }
  
  protected Image _getImageInternal(final Map.Entry<String, Object> element) {
    return this.adapterFactoryLabelProvider.getImage(element.getValue());
  }
  
  protected Image _getImageInternal(final Pair<String, Object> element) {
    return this.adapterFactoryLabelProvider.getImage(element.getValue());
  }
  
  protected Image _getImageInternal(final Object element) {
    return this.adapterFactoryLabelProvider.getImage(element);
  }
  
  @Override
  public String getText(final Object element) {
    return this.getTextInternal(element);
  }
  
  protected String _getTextInternal(final ViatraQueryEngine element) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Manage engine (hashcode: ");
    int _hashCode = element.hashCode();
    _builder.append(_hashCode);
    _builder.append(")");
    return _builder.toString();
  }
  
  protected String _getTextInternal(final BaseIndexOptions element) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Base index options: ");
    String _string = element.toString();
    _builder.append(_string);
    return _builder.toString();
  }
  
  protected String _getTextInternal(final ViatraQueryEngineOptions element) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Engine options: ");
    String _string = element.toString();
    _builder.append(_string);
    return _builder.toString();
  }
  
  protected String _getTextInternal(final IQueryBackendFactory element) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Backend factory: ");
    String _simpleName = element.getBackendClass().getSimpleName();
    _builder.append(_simpleName);
    return _builder.toString();
  }
  
  protected String _getTextInternal(final QueryEvaluationHint element) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Query evaluation hint");
    return _builder.toString();
  }
  
  protected String _getTextInternal(final Map.Entry<String, Object> element) {
    StringConcatenation _builder = new StringConcatenation();
    String _key = element.getKey();
    _builder.append(_key);
    _builder.append(": ");
    Object _or = Optional.<Object>fromNullable(element.getValue()).or("null");
    _builder.append(_or);
    return _builder.toString();
  }
  
  protected String _getTextInternal(final Pair<String, Object> element) {
    StringConcatenation _builder = new StringConcatenation();
    String _key = element.getKey();
    _builder.append(_key);
    _builder.append(": ");
    Object _or = Optional.<Object>fromNullable(element.getValue()).or("null");
    _builder.append(_or);
    return _builder.toString();
  }
  
  protected String _getTextInternal(final EngineError element) {
    String _message = element.getMessage();
    return ("Engine tainted: " + _message);
  }
  
  protected String _getTextInternal(final Object element) {
    return this.adapterFactoryLabelProvider.getText(element);
  }
  
  public Image getImageInternal(final Object element) {
    if (element instanceof Pair) {
      return _getImageInternal((Pair<String, Object>)element);
    } else if (element instanceof Map.Entry) {
      return _getImageInternal((Map.Entry<String, Object>)element);
    } else if (element instanceof ViatraQueryEngine) {
      return _getImageInternal((ViatraQueryEngine)element);
    } else if (element instanceof ViatraQueryEngineOptions) {
      return _getImageInternal((ViatraQueryEngineOptions)element);
    } else if (element instanceof BaseIndexOptions) {
      return _getImageInternal((BaseIndexOptions)element);
    } else if (element instanceof IQueryBackendFactory) {
      return _getImageInternal((IQueryBackendFactory)element);
    } else if (element instanceof QueryEvaluationHint) {
      return _getImageInternal((QueryEvaluationHint)element);
    } else if (element instanceof EngineError) {
      return _getImageInternal((EngineError)element);
    } else if (element != null) {
      return _getImageInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
  
  public String getTextInternal(final Object element) {
    if (element instanceof Pair) {
      return _getTextInternal((Pair<String, Object>)element);
    } else if (element instanceof Map.Entry) {
      return _getTextInternal((Map.Entry<String, Object>)element);
    } else if (element instanceof ViatraQueryEngine) {
      return _getTextInternal((ViatraQueryEngine)element);
    } else if (element instanceof ViatraQueryEngineOptions) {
      return _getTextInternal((ViatraQueryEngineOptions)element);
    } else if (element instanceof BaseIndexOptions) {
      return _getTextInternal((BaseIndexOptions)element);
    } else if (element instanceof IQueryBackendFactory) {
      return _getTextInternal((IQueryBackendFactory)element);
    } else if (element instanceof QueryEvaluationHint) {
      return _getTextInternal((QueryEvaluationHint)element);
    } else if (element instanceof EngineError) {
      return _getTextInternal((EngineError)element);
    } else if (element != null) {
      return _getTextInternal(element);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element).toString());
    }
  }
}
