/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.internal.core.UiMessages;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.preferences.bind.AbstractBindingPreferencesPage;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.ui.AbstractBindingComposite;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.osgi.service.prefs.BackingStoreException;

public abstract class LayoutsPreferencePage
extends AbstractBindingPreferencesPage {
    public LayoutsPreferencePage(ToolkitDescription toolkit) {
        super(toolkit);
    }

    protected AbstractBindingComposite createBindingComposite(Composite parent) {
        return new ContentsComposite(parent, this.m_bindManager, this.m_preferences);
    }

    public boolean performOk() {
        try {
            InstanceScope.INSTANCE.getNode("layout.available").flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    private static boolean isLayoutAvailable(LayoutDescription layout) {
        return InstanceScope.INSTANCE.getNode("layout.available").getBoolean(layout.getLayoutClassName(), false);
    }

    protected class ContentsComposite
    extends AbstractBindingComposite {
        public ContentsComposite(Composite parent, DataBindManager bindManager, IPreferenceStore preferences) {
            super(parent, bindManager, preferences);
            int gridLayoutColumns = 2;
            GridLayoutFactory.create((Composite)this).noMargins().columns(gridLayoutColumns);
            new Label((Composite)this, 0).setText(UiMessages.LayoutsPreferencePage_defaultLayout);
            final Combo layoutCombo = new Combo((Composite)this, 8);
            GridDataFactory.create((Control)layoutCombo).grabH().fillH();
            UiUtils.setVisibleItemCount((Combo)layoutCombo, (int)15);
            final List layouts = LayoutDescriptionHelper.get((ToolkitDescription)LayoutsPreferencePage.this.m_toolkit);
            Collections.sort(layouts, new Comparator<LayoutDescription>(){

                @Override
                public int compare(LayoutDescription layout_1, LayoutDescription layout_2) {
                    return layout_1.getName().compareTo(layout_2.getName());
                }
            });
            layoutCombo.add(UiMessages.LayoutsPreferencePage_implicitLayout);
            for (LayoutDescription layoutDescription : layouts) {
                layoutCombo.add(layoutDescription.getName());
            }
            layoutCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = layoutCombo.getSelectionIndex();
                    LayoutDescription layout = (LayoutDescription)layouts.get(index - 1);
                    if (!LayoutsPreferencePage.isLayoutAvailable(layout)) {
                        layoutCombo.select(0);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.m_bindManager.bind(new IDataEditor(){

                public void setValue(Object value) {
                    String id = (String)value;
                    if (StringUtils.isEmpty((String)id)) {
                        layoutCombo.select(0);
                        return;
                    }
                    int index = 0;
                    while (index < layouts.size()) {
                        LayoutDescription layout = (LayoutDescription)layouts.get(index);
                        if (layout.getId().equals(id)) {
                            layoutCombo.select(1 + index);
                        }
                        ++index;
                    }
                }

                public Object getValue() {
                    int index = layoutCombo.getSelectionIndex();
                    if (index <= 0) {
                        return null;
                    }
                    LayoutDescription layout = (LayoutDescription)layouts.get(index - 1);
                    if (LayoutsPreferencePage.isLayoutAvailable(layout)) {
                        return layout.getId();
                    }
                    return null;
                }
            }, (IDataProvider)new StringPreferenceProvider(this.m_preferences, "layout.default"), true);
            new Label((Composite)this, 0).setText(UiMessages.LayoutsPreferencePage_availableLayouts);
            Table table = new Table((Composite)this, 2848);
            for (LayoutDescription layout : layouts) {
                TableItem checkItem = new TableItem(table, 0);
                checkItem.setText(layout.getName());
                checkItem.setData((Object)layout);
                checkItem.setChecked(InstanceScope.INSTANCE.getNode("layout.available").getBoolean(layout.getLayoutClassName(), true));
            }
            table.addListener(13, event -> {
                if (event.detail == 32) {
                    InstanceScope.INSTANCE.getNode("layout.available").putBoolean(((LayoutDescription)((TableItem)event.item).getData()).getLayoutClassName(), ((TableItem)event.item).getChecked());
                }
                if (!((TableItem)event.item).getChecked() && ((LayoutDescription)((TableItem)event.item).getData()).getName().contentEquals(layoutCombo.getText())) {
                    layoutCombo.select(0);
                }
            });
            GridDataFactory.create((Control)table).fillH().spanH(gridLayoutColumns);
            this.checkButton((Composite)this, 2, UiMessages.LayoutsPreferencePage_inheritLayout, "layout.inheritLayoutOfParent");
        }
    }
}

