/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSLinkConverter;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class AttrFormatter
extends DefaultCSSSourceFormatter {
    private static AttrFormatter instance;

    AttrFormatter() {
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        ICSSAttr attr = (ICSSAttr)node;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int end = ((IndexedRegion)node).getEndOffset();
        if (end > 0) {
            int start = ((IndexedRegion)node).getStartOffset();
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            if (attr.getName().equals("selector") || attr.getName().equals("selector")) {
                int i = 0;
                while (i < regions.length) {
                    if (i != 0) {
                        this.appendSpaceBetween(node, regions[i - 1], regions[i], source);
                    }
                    source.append(this.decoratedRegion(regions[i], 0, stgy));
                    ++i;
                }
            } else if (attr.getName().equals("href")) {
                int i = 0;
                while (i < regions.length) {
                    if (i != 0) {
                        this.appendSpaceBefore(node, regions[i], source);
                    }
                    source.append(this.decoratedPropValueRegion(regions[i], stgy));
                    ++i;
                }
            } else if (attr.getName().equals("encoding")) {
                int i = 0;
                while (i < regions.length) {
                    if (i != 0) {
                        this.appendSpaceBefore(node, regions[i], source);
                    }
                    source.append(this.decoratedIdentRegion(regions[i], stgy));
                    ++i;
                }
            } else if (attr.getName().equals("important")) {
                int i = 0;
                while (i < regions.length) {
                    if (i != 0) {
                        this.appendSpaceBefore(node, regions[i], source);
                    }
                    source.append(this.decoratedPropValueRegion(regions[i], stgy));
                    ++i;
                }
            } else if (attr.getName() == null || attr.getName().length() == 0) {
                int i = 0;
                while (i < regions.length) {
                    if (i != 0) {
                        this.appendSpaceBefore(node, regions[i], source);
                    }
                    source.append(this.decoratedIdentRegion(regions[i], stgy));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < regions.length) {
                    if (i != 0) {
                        this.appendSpaceBefore(node, regions[i], source);
                    }
                    source.append(this.decoratedPropValueRegion(regions[i], stgy));
                    ++i;
                }
            }
        } else {
            Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
            String value = attr.getValue();
            if (value == null) {
                value = "";
            }
            if (!attr.getName().equals("selector") && !attr.getName().equals("selector")) {
                if (attr.getName().equals("href")) {
                    String func;
                    String uri = CSSLinkConverter.stripFunc(value);
                    String string = func = preferences.getInt("propValueCase") == 2 ? "URL(" : "url(";
                    if (preferences.getBoolean("quoteInURI")) {
                        String quote = preferences.getString("quote");
                        quote = CSSUtil.detectQuote(uri, quote);
                        value = String.valueOf(func) + quote + uri + quote + ")";
                    } else {
                        value = String.valueOf(func) + uri + ")";
                    }
                } else if (attr.getName().equals("encoding")) {
                    String quote = preferences.getString("quote");
                    if (!value.startsWith("\"") && !value.startsWith("'")) {
                        value = String.valueOf(quote) + value;
                    }
                    if (!value.endsWith("\"") && !value.endsWith("'")) {
                        value = String.valueOf(value) + quote;
                    }
                } else {
                    value = attr.getName().equals("important") ? (preferences.getInt("propValueCase") == 2 ? value.toUpperCase() : value.toLowerCase()) : (attr.getName() == null || attr.getName().length() == 0 ? (CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2 ? value.toUpperCase() : value.toLowerCase()) : (preferences.getInt("propValueCase") == 2 ? value.toUpperCase() : value.toLowerCase()));
                }
            }
            source.append(value);
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        this.formatPre(node, source);
    }

    public static synchronized AttrFormatter getInstance() {
        if (instance == null) {
            instance = new AttrFormatter();
        }
        return instance;
    }
}

