/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.ui.utils;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.ws.internal.converter.IIFile2UriConverter;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;

public class AdapterUtils {
    public static boolean hasAdapter(Object object) {
        if (object == null) {
            return false;
        }
        boolean hasAdapter = Platform.getAdapterManager().hasAdapter(object, "org.eclipse.core.resource.IFile");
        if (!hasAdapter) {
            hasAdapter = Platform.getAdapterManager().hasAdapter(object, "java.lang.String");
        }
        return hasAdapter;
    }

    public static Object getAdaptedObject(Object object) {
        if (object == null) {
            return null;
        }
        Object adaptedObject = Platform.getAdapterManager().loadAdapter(object, "java.lang.String");
        if (adaptedObject == null) {
            adaptedObject = Platform.getAdapterManager().loadAdapter(object, "org.eclipse.core.resources.IFile");
        }
        return adaptedObject;
    }

    public static String getAdaptedWSDL(Object object) {
        String wsdlURI = null;
        Object adaptedObject = AdapterUtils.getAdaptedObject(object);
        if (adaptedObject != null) {
            if (adaptedObject instanceof IFile) {
                URI uri;
                IFile file = (IFile)adaptedObject;
                boolean allowBaseConversionOnFailure = true;
                IIFile2UriConverter converter = WSPlugin.getInstance().getIFile2UriConverter();
                if (converter != null) {
                    wsdlURI = converter.convert(file);
                    allowBaseConversionOnFailure = converter.allowBaseConversionOnFailure();
                }
                if (wsdlURI == null && allowBaseConversionOnFailure && (uri = file.getLocationURI()) != null) {
                    wsdlURI = uri.toString();
                }
            } else if (adaptedObject instanceof String) {
                wsdlURI = (String)adaptedObject;
            }
        }
        return wsdlURI;
    }
}

