/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.ContainerChange;

final class ImmutableContainerChange
implements ContainerChange {
    private final String path;
    private final Integer kind;

    private ImmutableContainerChange(String path, Integer kind) {
        this.path = path;
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="Path")
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="Kind")
    public Integer kind() {
        return this.kind;
    }

    public final ImmutableContainerChange withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerChange(newValue, this.kind);
    }

    public final ImmutableContainerChange withKind(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerChange(this.path, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerChange && this.equalTo((ImmutableContainerChange)another);
    }

    private boolean equalTo(ImmutableContainerChange another) {
        return this.path.equals(another.path) && this.kind.equals(another.kind);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.kind.hashCode();
        return h;
    }

    public String toString() {
        return "ContainerChange{path=" + this.path + ", kind=" + this.kind + "}";
    }

    public static ImmutableContainerChange copyOf(ContainerChange instance) {
        if (instance instanceof ImmutableContainerChange) {
            return (ImmutableContainerChange)instance;
        }
        return ImmutableContainerChange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ContainerChange.Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_KIND = 2L;
        private long initBits = 3L;
        private String path;
        private Integer kind;

        private Builder() {
        }

        public final Builder from(ContainerChange instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            this.kind(instance.kind());
            return this;
        }

        @Override
        @JsonProperty(value="Path")
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Kind")
        public final Builder kind(Integer kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableContainerChange build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerChange(this.path, this.kind);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("kind");
            }
            return "Cannot build ContainerChange, some of required attributes are not set " + attributes;
        }
    }
}

