/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FormElement;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.FiresFormEvents;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.impl.FormPanelImpl;
import com.google.gwt.user.client.ui.impl.FormPanelImplHost;

public class FormPanel
extends SimplePanel
implements FiresFormEvents,
FormPanelImplHost {
    public static final String ENCODING_MULTIPART = "multipart/form-data";
    public static final String ENCODING_URLENCODED = "application/x-www-form-urlencoded";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static int formId = 0;
    private static FormPanelImpl impl = (FormPanelImpl)GWT.create(FormPanelImpl.class);
    private String frameName;
    private Element synthesizedFrame;

    public static FormPanel wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        FormPanel formPanel = new FormPanel(element);
        formPanel.onAttach();
        RootPanel.detachOnWindowClose(formPanel);
        return formPanel;
    }

    public static FormPanel wrap(Element element, boolean createIFrame) {
        assert (Document.get().getBody().isOrHasChild(element));
        FormPanel formPanel = new FormPanel(element, createIFrame);
        formPanel.onAttach();
        RootPanel.detachOnWindowClose(formPanel);
        return formPanel;
    }

    public FormPanel() {
        this(Document.get().createFormElement(), true);
    }

    public FormPanel(NamedFrame frameTarget) {
        this(frameTarget.getName());
    }

    public FormPanel(String target) {
        super(Document.get().createFormElement());
        this.setTarget(target);
    }

    protected FormPanel(Element element) {
        this(element, false);
    }

    protected FormPanel(Element element, boolean createIFrame) {
        super(element);
        FormElement.as(element);
        if (createIFrame) {
            assert (this.getTarget() == null || this.getTarget().trim().length() == 0) : "Cannot create target iframe if the form's target is already set.";
            this.frameName = "FormPanel_" + GWT.getModuleName() + "_" + ++formId;
            this.setTarget(this.frameName);
            this.sinkEvents(32768);
        }
    }

    @Deprecated
    public void addFormHandler(FormHandler handler) {
        ListenerWrapper.WrappedOldFormHandler.add(this, handler);
    }

    public HandlerRegistration addSubmitCompleteHandler(SubmitCompleteHandler handler) {
        return this.addHandler(handler, SubmitCompleteEvent.getType());
    }

    public HandlerRegistration addSubmitHandler(SubmitHandler handler) {
        return this.addHandler(handler, SubmitEvent.getType());
    }

    public String getAction() {
        return this.getFormElement().getAction();
    }

    public String getEncoding() {
        return impl.getEncoding(this.getElement());
    }

    public String getMethod() {
        return this.getFormElement().getMethod();
    }

    public String getTarget() {
        return this.getFormElement().getTarget();
    }

    public boolean onFormSubmit() {
        return this.onFormSubmitImpl();
    }

    public void onFrameLoad() {
        this.onFrameLoadImpl();
    }

    @Deprecated
    public void removeFormHandler(FormHandler handler) {
        ListenerWrapper.WrappedOldFormHandler.remove(this, handler);
    }

    public void reset() {
        impl.reset(this.getElement());
    }

    public void setAction(String url) {
        this.getFormElement().setAction(url);
    }

    public void setEncoding(String encodingType) {
        impl.setEncoding(this.getElement(), encodingType);
    }

    public void setMethod(String method) {
        this.getFormElement().setMethod(method);
    }

    public void submit() {
        if (!this.fireSubmitEvent()) {
            return;
        }
        impl.submit(this.getElement(), this.synthesizedFrame);
    }

    protected void onAttach() {
        super.onAttach();
        if (this.frameName != null) {
            this.createFrame();
            Document.get().getBody().appendChild(this.synthesizedFrame);
        }
        impl.hookEvents(this.synthesizedFrame, this.getElement(), this);
    }

    protected void onDetach() {
        super.onDetach();
        impl.unhookEvents(this.synthesizedFrame, this.getElement());
        if (this.synthesizedFrame != null) {
            Document.get().getBody().removeChild(this.synthesizedFrame);
            this.synthesizedFrame = null;
        }
    }

    Element getSynthesizedIFrame() {
        return this.synthesizedFrame;
    }

    private void createFrame() {
        DivElement dummy = Document.get().createDivElement();
        dummy.setInnerHTML("<iframe src=\"javascript:''\" name='" + this.frameName + "' style='position:absolute;width:0;height:0;border:0'>");
        this.synthesizedFrame = dummy.getFirstChildElement();
    }

    private boolean fireSubmitEvent() {
        SubmitEvent event = new SubmitEvent();
        this.fireEvent(event);
        return !event.isCanceled();
    }

    private FormElement getFormElement() {
        return (FormElement)this.getElement().cast();
    }

    private boolean onFormSubmitImpl() {
        return this.fireSubmitEvent();
    }

    private void onFrameLoadImpl() {
        DeferredCommand.addCommand(new Command(){

            public void execute() {
                FormPanel.this.fireEvent(new SubmitCompleteEvent(impl.getContents(FormPanel.this.synthesizedFrame)));
            }
        });
    }

    private void setTarget(String target) {
        this.getFormElement().setTarget(target);
    }

    public static interface SubmitHandler
    extends EventHandler {
        public void onSubmit(SubmitEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubmitEvent
    extends GwtEvent<SubmitHandler> {
        private static GwtEvent.Type<SubmitHandler> TYPE = new GwtEvent.Type();
        private boolean canceled = false;

        static GwtEvent.Type<SubmitHandler> getType() {
            if (TYPE == null) {
                TYPE = new GwtEvent.Type();
            }
            return TYPE;
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public final GwtEvent.Type<SubmitHandler> getAssociatedType() {
            return TYPE;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        protected void dispatch(SubmitHandler handler) {
            handler.onSubmit(this);
        }

        @Deprecated
        void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }

    public static interface SubmitCompleteHandler
    extends EventHandler {
        public void onSubmitComplete(SubmitCompleteEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubmitCompleteEvent
    extends GwtEvent<SubmitCompleteHandler> {
        private static GwtEvent.Type<SubmitCompleteHandler> TYPE;
        private String resultHtml;

        static GwtEvent.Type<SubmitCompleteHandler> getType() {
            if (TYPE == null) {
                TYPE = new GwtEvent.Type();
            }
            return TYPE;
        }

        protected SubmitCompleteEvent(String resultsHtml) {
            this.resultHtml = resultsHtml;
        }

        @Override
        public final GwtEvent.Type<SubmitCompleteHandler> getAssociatedType() {
            return TYPE;
        }

        public String getResults() {
            return this.resultHtml;
        }

        @Override
        protected void dispatch(SubmitCompleteHandler handler) {
            handler.onSubmitComplete(this);
        }
    }
}

