/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.Sequence;
import com.google.gwtorm.client.StatementExecutor;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.sql.SqlBooleanTypeInfo;
import com.google.gwtorm.schema.sql.SqlByteArrayTypeInfo;
import com.google.gwtorm.schema.sql.SqlCharTypeInfo;
import com.google.gwtorm.schema.sql.SqlDateTypeInfo;
import com.google.gwtorm.schema.sql.SqlIntTypeInfo;
import com.google.gwtorm.schema.sql.SqlLongTypeInfo;
import com.google.gwtorm.schema.sql.SqlShortTypeInfo;
import com.google.gwtorm.schema.sql.SqlStringTypeInfo;
import com.google.gwtorm.schema.sql.SqlTimestampTypeInfo;
import com.google.gwtorm.schema.sql.SqlTypeInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class SqlDialect {
    protected final Map<Class<?>, SqlTypeInfo> types = new HashMap();
    protected final Map<Integer, String> typeNames;

    protected SqlDialect() {
        this.types.put(Boolean.TYPE, new SqlBooleanTypeInfo());
        this.types.put(Short.TYPE, new SqlShortTypeInfo());
        this.types.put(Integer.TYPE, new SqlIntTypeInfo());
        this.types.put(Long.TYPE, new SqlLongTypeInfo());
        this.types.put(Character.TYPE, new SqlCharTypeInfo());
        this.types.put(String.class, new SqlStringTypeInfo());
        this.types.put(Date.class, new SqlDateTypeInfo());
        this.types.put(Timestamp.class, new SqlTimestampTypeInfo());
        this.types.put(byte[].class, new SqlByteArrayTypeInfo());
        this.typeNames = new HashMap<Integer, String>();
        this.typeNames.put(-3, "BLOB");
        this.typeNames.put(91, "DATE");
        this.typeNames.put(5, "SMALLINT");
        this.typeNames.put(4, "INT");
        this.typeNames.put(-5, "BIGINT");
        this.typeNames.put(-1, "TEXT");
        this.typeNames.put(93, "TIMESTAMP");
    }

    public SqlDialect refine(Connection c) throws SQLException {
        return this;
    }

    public String getSqlTypeName(int typeCode) {
        String r = this.typeNames.get(typeCode);
        return r != null ? r : "UNKNOWNTYPE";
    }

    public SqlTypeInfo getSqlTypeInfo(ColumnModel col) {
        return this.getSqlTypeInfo(col.getPrimitiveType());
    }

    public SqlTypeInfo getSqlTypeInfo(Class<?> t) {
        return this.types.get(t);
    }

    public String getParameterPlaceHolder(int nthParameter) {
        return "?";
    }

    public boolean selectHasLimit() {
        return true;
    }

    protected static String getSQLState(SQLException err) {
        String ec;
        SQLException next = err;
        do {
            ec = next.getSQLState();
            next = next.getNextException();
        } while (ec == null && next != null);
        return ec;
    }

    protected static int getSQLStateInt(SQLException err) {
        String s = SqlDialect.getSQLState(err);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    public OrmException convertError(String op, String entity, SQLException err) {
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return new OrmException(op + " failure on " + entity, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long nextLong(Connection conn, String query) throws OrmException {
        try {
            Statement st = conn.createStatement();
            try {
                long l;
                ResultSet rs = st.executeQuery(query);
                try {
                    if (!rs.next()) {
                        throw new SQLException("No result row for sequence query");
                    }
                    long r = rs.getLong(1);
                    if (rs.next()) {
                        throw new SQLException("Too many results from sequence query");
                    }
                    l = r;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return l;
            }
            finally {
                st.close();
            }
        }
        catch (SQLException e) {
            throw this.convertError("sequence", query, e);
        }
    }

    public String getCreateSequenceSql(SequenceModel seq) {
        Sequence s = seq.getSequence();
        StringBuilder r = new StringBuilder();
        r.append("CREATE SEQUENCE ");
        r.append(seq.getSequenceName());
        if (s.startWith() > 0L) {
            r.append(" START WITH ");
            r.append(s.startWith());
        }
        if (s.cache() > 0) {
            r.append(" CACHE ");
            r.append(s.cache());
        }
        return r.toString();
    }

    public String getDropSequenceSql(String name) {
        return "DROP SEQUENCE " + name;
    }

    public void appendCreateTableStorage(StringBuilder sqlBuffer, RelationModel relationModel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listTables(Connection db) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = db.getMetaData().getTables(null, null, null, types);
        try {
            HashSet<String> tables = new HashSet<String>();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME").toLowerCase());
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            rs.close();
        }
    }

    public abstract Set<String> listSequences(Connection var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listColumns(Connection db, String tableName) throws SQLException {
        DatabaseMetaData meta = db.getMetaData();
        if (meta.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (meta.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        ResultSet rs = meta.getColumns(null, null, tableName, null);
        try {
            HashSet<String> columns = new HashSet<String>();
            while (rs.next()) {
                columns.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
            HashSet<String> hashSet = columns;
            return hashSet;
        }
        finally {
            rs.close();
        }
    }

    public void addColumn(StatementExecutor e, String tableName, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" ADD ");
        r.append(col.getColumnName());
        r.append(" ");
        r.append(this.getSqlTypeInfo(col).getSqlType(col, this));
        String check = this.getSqlTypeInfo(col).getCheckConstraint(col, this);
        if (check != null) {
            r.append(' ');
            r.append(check);
        }
        e.execute(r.toString());
    }

    public void dropColumn(StatementExecutor e, String tableName, String column) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" DROP COLUMN ");
        r.append(column);
        e.execute(r.toString());
    }

    public abstract void renameColumn(StatementExecutor var1, String var2, String var3, ColumnModel var4) throws OrmException;

    public abstract String getNextSequenceValueSql(String var1);
}

