/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.bpmn2.di.impl.BpmnDiPackageImpl;
import org.eclipse.bpmn2.impl.Bpmn2PackageImpl;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.ui.IConstants;
import org.eclipse.bpmn2.modeler.ui.Messages;
import org.eclipse.bpmn2.modeler.ui.adapters.Bpmn2EditorDiItemProviderAdapterFactory;
import org.eclipse.bpmn2.modeler.ui.adapters.Bpmn2EditorItemProviderAdapterFactory;
import org.eclipse.bpmn2.modeler.ui.adapters.Bpmn2WSDLAdapterFactory;
import org.eclipse.bpmn2.modeler.ui.adapters.Bpmn2XSDAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.xsd.XSDPackage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.bpmn2.modeler.ui";
    private static Activator plugin;
    public static final String UI_EXTENSION_ID = "org.eclipse.bpmn2.modeler.ui";

    static {
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)WSDLPackage.eINSTANCE, (AdapterFactory)Bpmn2WSDLAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)XSDPackage.eINSTANCE, (AdapterFactory)Bpmn2XSDAdapterFactory.getInstance());
        AdapterRegistry.BPMN2_ADAPTER_FACTORIES.addAdapterFactory(AdapterRegistry.INSTANCE.registerFactory((Object)Bpmn2PackageImpl.eINSTANCE, (AdapterFactory)new Bpmn2EditorItemProviderAdapterFactory()));
        AdapterRegistry.BPMN2_ADAPTER_FACTORIES.addAdapterFactory(AdapterRegistry.INSTANCE.registerFactory((Object)BpmnDiPackageImpl.eINSTANCE, (AdapterFactory)new Bpmn2EditorDiItemProviderAdapterFactory()));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logStatus(IStatus status) {
        Platform.getLog((Bundle)plugin.getBundle()).log(status);
    }

    public static void logError(Exception e) {
        Activator.logStatus((IStatus)Activator.createStatus(e));
    }

    private static Status createStatus(Exception e) {
        return new Status(4, "org.eclipse.bpmn2.modeler.ui", e.getMessage(), (Throwable)e);
    }

    public static void showErrorWithLogging(Exception e) {
        Status s = Activator.createStatus(e);
        Activator.logStatus((IStatus)s);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.Activator_Error, null, (IStatus)s);
    }

    public IDialogSettings getDialogSettingsFor(Object object) {
        IDialogSettings main;
        IDialogSettings settings;
        String name = object.getClass().getName();
        if (object instanceof String) {
            name = (String)object;
        }
        if ((settings = (main = this.getDialogSettings()).getSection(name)) == null) {
            settings = main.addNewSection(name);
        }
        return settings;
    }

    public String getID() {
        return this.getBundle().getSymbolicName();
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = super.createImageRegistry();
        URL baseURL = this.getBundle().getEntry("/");
        Field[] fields = IConstants.class.getFields();
        int i = 0;
        while (i < fields.length) {
            String name;
            Field f = fields[i];
            if (f.getType() == String.class && ((name = f.getName()).startsWith("ICON_") || name.startsWith("CURSOR_") || name.startsWith("IMAGE_"))) {
                try {
                    String value = (String)f.get(null);
                    this.createImageDescriptor(registry, value, baseURL);
                }
                catch (Exception e) {
                    Activator.logError(e);
                }
            }
            ++i;
        }
        return registry;
    }

    private void createImageDescriptor(ImageRegistry registry, String id, URL baseURL) {
        URL url = null;
        try {
            url = new URL(baseURL, "icons/" + id);
        }
        catch (MalformedURLException e) {
            Activator.logError(e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        registry.put(id, desc);
    }

    public Image getImage(String id) {
        return this.getImageRegistry().get(id);
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.getImageRegistry().getDescriptor(id);
    }
}

