/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCommands;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class DefaultGCCDependencyCalculator3Commands
implements IManagedDependencyCommands {
    private static final String EMPTY_STRING = "";
    IPath source;
    IResource resource;
    IBuildObject buildContext;
    ITool tool;
    IPath topBuildDirectory;
    IProject project;
    IConfiguration config;
    private IResourceInfo resInfo;
    IPath sourceLocation;
    IPath outputLocation;
    boolean needExplicitRuleForFile;
    boolean genericCommands = true;

    public DefaultGCCDependencyCalculator3Commands(IPath source, IResource resource, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this.source = source;
        this.resource = resource;
        this.buildContext = buildContext;
        this.tool = tool;
        this.topBuildDirectory = topBuildDirectory;
        if (buildContext instanceof IConfiguration) {
            this.config = (IConfiguration)buildContext;
            this.resInfo = this.config.getRootFolderInfo();
            this.project = (IProject)this.config.getOwner();
        } else if (buildContext instanceof IResourceInfo) {
            this.resInfo = (IResourceInfo)buildContext;
            this.config = this.resInfo.getParent();
            this.project = (IProject)this.config.getOwner();
        }
        this.sourceLocation = source.isAbsolute() ? source : this.project.getLocation().append(source);
        this.outputLocation = this.project.getLocation().append(topBuildDirectory).append(this.getDependencyFiles()[0]);
        boolean resourceNameRequiresExplicitRule = true;
        if (resource != null) {
            resourceNameRequiresExplicitRule = resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(this.sourceLocation.toString()) || !resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(resource.getProjectRelativePath().toString());
        }
        boolean bl = this.needExplicitRuleForFile = resourceNameRequiresExplicitRule || BuildMacroProvider.getReferencedExplitFileMacros(tool).length > 0 || BuildMacroProvider.getReferencedExplitFileMacros(tool.getToolCommand(), 1, new FileContextData(this.sourceLocation, this.outputLocation, null, tool)).length > 0;
        if (buildContext instanceof IResourceConfiguration || this.needExplicitRuleForFile) {
            this.genericCommands = false;
        }
    }

    public DefaultGCCDependencyCalculator3Commands(IPath source, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this(source, null, buildContext, tool, topBuildDirectory);
    }

    @Override
    public boolean areCommandsGeneric() {
        return this.genericCommands;
    }

    @Override
    public String[] getDependencyCommandOptions() {
        return null;
    }

    @Override
    public IPath[] getDependencyFiles() {
        IPath depFilePath = this.source.removeFileExtension().addFileExtension("d");
        if (!depFilePath.isAbsolute() && this.topBuildDirectory.isPrefixOf(depFilePath)) {
            depFilePath = depFilePath.removeFirstSegments(1);
        }
        IPath[] paths = new IPath[]{depFilePath};
        return paths;
    }

    @Override
    public String[] getPostToolDependencyCommands() {
        String[] commands = new String[2];
        String inputExtension = this.source.getFileExtension();
        String outputExtension = this.tool.getOutputExtension(inputExtension);
        String depRule = "'$(@:%." + outputExtension + "=%." + "d" + ")'";
        commands[0] = "\techo -n " + depRule + " " + "$(dir $@)" + " " + ">" + " " + depRule;
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        IManagedCommandLineInfo cmdLInfo = null;
        String buildCmd = null;
        String[] inputs = new String[]{"$<"};
        String outputFile = EMPTY_STRING;
        String outflag = EMPTY_STRING;
        String outputPrefix = EMPTY_STRING;
        String cmd = this.tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = !this.needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool)) : provider.resolveValue(cmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException resolvedCommand) {
            // empty catch block
        }
        String[] toolFlags = null;
        try {
            toolFlags = this.tool.getToolCommandFlags(this.sourceLocation, this.outputLocation);
        }
        catch (BuildException ex) {
            toolFlags = new String[]{};
        }
        String[] flags = new String[toolFlags.length + 4];
        flags[0] = "-MM";
        flags[1] = "-MG";
        flags[2] = "-P";
        flags[3] = "-w";
        int i = 0;
        while (i < toolFlags.length) {
            flags[4 + i] = toolFlags[i];
            ++i;
        }
        IManagedCommandLineGenerator cmdLGen = this.tool.getCommandLineGenerator();
        cmdLInfo = cmdLGen.generateCommandLineInfo(this.tool, cmd, flags, outflag, outputPrefix, outputFile, inputs, this.tool.getCommandLinePattern());
        buildCmd = cmdLInfo.getCommandLine();
        try {
            String resolvedCommand = null;
            resolvedCommand = !this.needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool)) : provider.resolveValue(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(this.sourceLocation, this.outputLocation, null, this.tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                buildCmd = resolvedCommand;
            }
        }
        catch (BuildMacroException buildMacroException) {
            // empty catch block
        }
        commands[1] = "\t" + buildCmd + " " + ">>" + " " + depRule;
        return commands;
    }

    @Override
    public String[] getPreToolDependencyCommands() {
        return null;
    }

    @Override
    public IBuildObject getBuildContext() {
        return this.buildContext;
    }

    @Override
    public IPath getSource() {
        return this.source;
    }

    @Override
    public ITool getTool() {
        return this.tool;
    }

    @Override
    public IPath getTopBuildDirectory() {
        return this.topBuildDirectory;
    }
}

