/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringContribution;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;

public class ScriptRefactoringDescriptor
extends RefactoringDescriptor {
    public static final String ATTRIBUTE_ELEMENT = "element";
    public static final String ATTRIBUTE_INPUT = "input";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_REFERENCES = "references";
    public static final String ATTRIBUTE_SELECTION = "selection";
    private static final String ATTRIBUTE_VERSION = "version";
    public static final int DEPRECATION_RESOLVING = 131072;
    public static final int ARCHIVE_IMPORTABLE = 65536;
    public static final int ARCHIVE_REFACTORABLE = 524288;
    private static final String VALUE_VERSION_1_0 = "1.0";
    protected final Map<String, String> fArguments;
    private ScriptRefactoringContribution fContribution;

    public static String elementToHandle(String project, IModelElement element) {
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IScriptProject)) {
            String id = element.getScriptProject().getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    public static IModelElement handleToElement(String project, String handle) {
        return ScriptRefactoringDescriptor.handleToElement(project, handle, true);
    }

    public static IModelElement handleToElement(String project, String handle, boolean check) {
        return ScriptRefactoringDescriptor.handleToElement(null, project, handle, check);
    }

    public static IModelElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IModelElement element = null;
        element = owner != null ? DLTKCore.create((String)handle, (WorkingCopyOwner)owner) : DLTKCore.create((String)handle);
        if (element == null && project != null) {
            IScriptProject scriptProject = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProject(project);
            String identifier = scriptProject.getHandleIdentifier();
            element = owner != null ? DLTKCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : DLTKCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODo: ScriptRefactoringDescriptor add find Methods member in types...");
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    public static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    public static String resourceToHandle(String project, IResource resource) {
        if (project != null && !"".equals(project)) {
            return resource.getProjectRelativePath().toPortableString();
        }
        return resource.getFullPath().toPortableString();
    }

    public ScriptRefactoringDescriptor(ScriptRefactoringContribution contribution, String id, String project, String description, String comment, Map<String, String> arguments, int flags) {
        super(id, project, description, comment, flags);
        Assert.isNotNull(arguments);
        this.fContribution = contribution;
        this.fArguments = arguments;
    }

    protected ScriptRefactoringDescriptor(String id) {
        this(id, null, DescriptorMessages.ScriptRefactoringDescriptor_not_available, null, new HashMap<String, String>(), 6);
    }

    public ScriptRefactoringDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) {
        this(null, id, project, description, comment, arguments, flags);
    }

    public RefactoringArguments createArguments() {
        ScriptRefactoringArguments arguments = new ScriptRefactoringArguments(this.getProject());
        for (Map.Entry<String, String> entry : this.fArguments.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null || "".equals(name) || value == null) continue;
            arguments.setAttribute(name, value);
        }
        return arguments;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        Refactoring refactoring = null;
        if (this.fContribution != null) {
            refactoring = this.fContribution.createRefactoring(this);
        } else {
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)this.getID());
            if (contribution instanceof ScriptRefactoringContribution) {
                this.fContribution = (ScriptRefactoringContribution)contribution;
                refactoring = this.fContribution.createRefactoring(this);
            }
        }
        if (refactoring != null) {
            if (refactoring instanceof IScriptableRefactoring) {
                RefactoringStatus result = ((IScriptableRefactoring)refactoring).initialize(this.createArguments());
                if (result.hasFatalError()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core.manipulation", 0, result.getMessageMatchingSeverity(4), null));
                }
                status.merge(result);
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.core.manipulation", 0, MessageFormat.format(DescriptorMessages.ScriptRefactoringDescriptor_no_resulting_descriptor, this.getDescription()), null));
            }
        }
        return refactoring;
    }

    public String elementToHandle(IModelElement element) {
        Assert.isNotNull((Object)element);
        return ScriptRefactoringDescriptor.elementToHandle(this.getProject(), element);
    }

    public Map<String, String> getArguments() {
        this.populateArgumentMap();
        return new HashMap<String, String>(this.fArguments);
    }

    protected void populateArgumentMap() {
        this.fArguments.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
    }

    public ScriptRefactoringContribution getContribution() {
        return this.fContribution;
    }
}

