/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.clipboard;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.clipboard.AWTViewImageTransferable;

public class AWTClipboardHelper {
    private static final String OVERRIDE_PROPERTY = "org.eclipse.gmf.runtime.image.copy.supported";
    private static final boolean IMAGE_COPY_SUPPORTED = AWTClipboardHelper.computeImageCopySupported();
    private static final AWTClipboardHelper INSTANCE = new AWTClipboardHelper();
    private Clipboard awtClipboard;

    public static AWTClipboardHelper getInstance() {
        return INSTANCE;
    }

    private AWTClipboardHelper() {
        if (this.isImageCopySupported()) {
            this.awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    public final boolean isImageCopySupported() {
        return IMAGE_COPY_SUPPORTED;
    }

    private static final boolean computeImageCopySupported() {
        String imageCopySupported = System.getProperty(OVERRIDE_PROPERTY);
        if (imageCopySupported == null) {
            boolean onWindows = System.getProperty("os.name").toUpperCase().startsWith("WIN");
            String javaVersion = System.getProperty("java.specification.version");
            boolean beforeJava11 = Arrays.asList("1.8", "9", "10").stream().anyMatch(javaVersion::equals);
            return onWindows && beforeJava11;
        }
        return Boolean.parseBoolean(imageCopySupported);
    }

    public boolean hasCustomData() {
        assert (this.isImageCopySupported());
        Transferable transferable = this.getClipboard().getContents(null);
        if (transferable != null) {
            DataFlavor[] dataFlavors = transferable.getTransferDataFlavors();
            int i = 0;
            while (i < dataFlavors.length) {
                if (dataFlavors[i].equals(AWTViewImageTransferable.AWTCUSTOMDATAFLAVOR)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public CustomData getCustomData() {
        assert (this.isImageCopySupported());
        Transferable transferable = this.getClipboard().getContents(null);
        if (transferable == null) {
            return null;
        }
        if (!this.hasCustomData()) {
            return null;
        }
        CustomData data = null;
        try {
            data = (CustomData)transferable.getTransferData(AWTViewImageTransferable.AWTCUSTOMDATAFLAVOR);
        }
        catch (UnsupportedFlavorException e) {
            Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_CATCHING, AWTClipboardHelper.class, (String)"getCustomData", (Throwable)e);
        }
        catch (IOException e) {
            Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_CATCHING, AWTClipboardHelper.class, (String)"getCustomData", (Throwable)e);
        }
        return data;
    }

    public void copyToClipboard(CustomData data, Image image) {
        assert (this.isImageCopySupported());
        this.getClipboard().setContents(new AWTViewImageTransferable((ICustomData)data, image), null);
    }

    private Clipboard getClipboard() {
        return this.awtClipboard;
    }
}

