/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.osgi.framework.Bundle;

public abstract class StorageDocumentProvider
extends AbstractDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document;
        if (element instanceof IStorageEditorInput && this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element)) {
            this.setupDocument(element, document);
            return document;
        }
        return null;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected abstract IDocument createEmptyDocument();

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IStorageEditorInput) {
            IDocument document = null;
            IStatus status = null;
            try {
                document = this.createDocument(element);
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.StorageDocumentProvider_createElementInfo);
                status = x.getStatus();
                document = this.createEmptyDocument();
            }
            AbstractDocumentProvider.ElementInfo info = this.createNewElementInfo(document);
            info.fStatus = status;
            return info;
        }
        return super.createElementInfo(element);
    }

    public AbstractDocumentProvider.ElementInfo createNewElementInfo(IDocument document) {
        return new StorageInfo(document);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (editorInput instanceof IStorageEditorInput) {
            IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
            this.setDocumentContentFromStorage(document, storage);
            return true;
        }
        return false;
    }

    protected abstract void setDocumentContentFromStorage(IDocument var1, IStorage var2) throws CoreException;

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    protected void updateCache(IStorageEditorInput input) throws CoreException {
        StorageInfo info = (StorageInfo)this.getElementInfo(input);
        if (info != null) {
            try {
                IStorage storage = input.getStorage();
                if (storage != null) {
                    boolean readOnly;
                    info.fIsReadOnly = readOnly = storage.isReadOnly();
                    info.fIsModifiable = !readOnly;
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, EditorMessages.StorageDocumentProvider_updateCache);
            }
            info.fUpdateCache = false;
        }
    }

    public boolean isReadOnly(Object element) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, EditorMessages.StorageDocumentProvider_isReadOnly);
                }
            }
            return info.fIsReadOnly;
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, EditorMessages.StorageDocumentProvider_isModifiable);
                }
            }
            return info.fIsModifiable;
        }
        return super.isModifiable(element);
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            info.fUpdateCache = true;
        }
        super.doUpdateStateCache(element);
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected class StorageInfo
    extends AbstractDocumentProvider.ElementInfo {
        public boolean fIsModifiable;
        public boolean fIsReadOnly;
        public boolean fUpdateCache;

        public StorageInfo(IDocument document) {
            super((AbstractDocumentProvider)StorageDocumentProvider.this, document);
            this.fIsModifiable = false;
            this.fIsReadOnly = true;
            this.fUpdateCache = true;
        }
    }
}

