/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class GFPerspective
implements IPerspectiveFactory {
    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
    }

    private void defineActions(IPageLayout layout) {
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        if (GFPerspective.isViewAvailable("org.eclipse.ui.views.ProgressView")) {
            layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
        }
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
    }

    private void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.26f, editorArea);
        if (GFPerspective.isViewAvailable("org.eclipse.jdt.ui.PackageExplorer")) {
            topLeft.addView("org.eclipse.jdt.ui.PackageExplorer");
        }
        if (GFPerspective.isViewAvailable("org.eclipse.ui.navigator.ProjectExplorer")) {
            topLeft.addView("org.eclipse.ui.navigator.ProjectExplorer");
        }
        topLeft.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        IFolderLayout bottomLeft = layout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        if (GFPerspective.isViewAvailable("org.eclipse.ui.views.ContentOutline")) {
            bottomLeft.addView("org.eclipse.ui.views.ContentOutline");
        }
        if (GFPerspective.isViewAvailable("org.eclipse.graphiti.ui.internal.editor.thumbnailview")) {
            bottomLeft.addView("org.eclipse.graphiti.ui.internal.editor.thumbnailview");
        }
        IFolderLayout bottomRight = layout.createFolder("bottomRight", 4, 0.66f, editorArea);
        if (GFPerspective.isViewAvailable("org.eclipse.pde.runtime.LogView")) {
            bottomRight.addView("org.eclipse.pde.runtime.LogView");
        }
        if (GFPerspective.isViewAvailable("org.eclipse.ui.views.PropertySheet")) {
            bottomRight.addView("org.eclipse.ui.views.PropertySheet");
        }
        if (GFPerspective.isViewAvailable("org.eclipse.ui.views.ProblemView")) {
            bottomRight.addView("org.eclipse.ui.views.ProblemView");
        }
    }

    private static boolean isViewAvailable(String viewId) {
        IViewDescriptor viewDesc = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
        return viewDesc != null;
    }
}

