/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.listener.awt.AWTListChangeListenerWrapper;
import org.eclipse.jpt.common.utility.internal.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.utility.internal.model.listener.awt.AWTStateChangeListenerWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.AbstractTreeModel;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.TreeNodeValueModel;

public class TreeModelAdapter<T>
extends AbstractTreeModel {
    private final PropertyValueModel<TreeNodeValueModel<T>> rootHolder;
    private final PropertyChangeListener rootListener;
    private final StateChangeListener nodeStateListener;
    private final PropertyChangeListener nodeValueListener;
    private final ListChangeListener childrenListener;
    private TreeNodeValueModel<T> root;
    final IdentityHashMap<TreeNodeValueModel<T>, List<TreeNodeValueModel<T>>> childrenLists;
    final IdentityHashMap<ListValueModel<TreeNodeValueModel<T>>, TreeNodeValueModel<T>> parents;
    private static final long serialVersionUID = 1L;

    public TreeModelAdapter(PropertyValueModel<TreeNodeValueModel<T>> rootHolder) {
        if (rootHolder == null) {
            throw new NullPointerException();
        }
        this.rootHolder = rootHolder;
        this.rootListener = this.buildRootListener();
        this.nodeStateListener = this.buildNodeStateListener();
        this.nodeValueListener = this.buildNodeValueListener();
        this.childrenListener = this.buildChildrenListener();
        this.childrenLists = new IdentityHashMap();
        this.parents = new IdentityHashMap();
    }

    public TreeModelAdapter(TreeNodeValueModel<T> root) {
        this(new StaticPropertyValueModel<TreeNodeValueModel<T>>(root));
    }

    protected PropertyChangeListener buildRootListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildRootListener_());
    }

    protected PropertyChangeListener buildRootListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                TreeModelAdapter.this.rootChanged();
            }

            public String toString() {
                return "root listener";
            }
        };
    }

    protected PropertyChangeListener buildNodeValueListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildNodeValueListener_());
    }

    protected PropertyChangeListener buildNodeValueListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)event.getSource());
            }

            public String toString() {
                return "node value listener";
            }
        };
    }

    protected StateChangeListener buildNodeStateListener() {
        return new AWTStateChangeListenerWrapper(this.buildNodeStateListener_());
    }

    protected StateChangeListener buildNodeStateListener_() {
        return new StateChangeListener(){

            @Override
            public void stateChanged(StateChangeEvent event) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)event.getSource());
            }

            public String toString() {
                return "node state listener";
            }
        };
    }

    protected ListChangeListener buildChildrenListener() {
        return new AWTListChangeListenerWrapper(this.buildChildrenListener_());
    }

    protected ListChangeListener buildChildrenListener_() {
        return new ListChangeListener(){

            @Override
            public void itemsAdded(ListAddEvent event) {
                new AddEventChangePolicy(event).addChildren();
            }

            @Override
            public void itemsRemoved(ListRemoveEvent event) {
                new RemoveEventChangePolicy(event).removeChildren();
            }

            @Override
            public void itemsReplaced(ListReplaceEvent event) {
                new ReplaceEventChangePolicy(event).replaceChildren();
            }

            @Override
            public void itemsMoved(ListMoveEvent event) {
                new MoveEventChangePolicy(event).moveChildren();
            }

            @Override
            public void listCleared(ListClearEvent event) {
                new ClearEventChangePolicy(event).clearChildren();
            }

            @Override
            public void listChanged(ListChangeEvent event) {
                new ChangeEventChangePolicy(event).rebuildChildren();
            }

            public String toString() {
                return "children listener";
            }
        };
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNodeValueModel)parent).child(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNodeValueModel)parent).childrenSize();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNodeValueModel)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        ((TreeNodeValueModel)path.getLastPathComponent()).setValue(newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNodeValueModel)parent).indexOfChild((TreeNodeValueModel)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this.hasNoTreeModelListeners()) {
            this.engageModel();
        }
        super.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        if (this.hasNoTreeModelListeners()) {
            this.disengageModel();
        }
    }

    private void engageModel() {
        this.rootHolder.addPropertyChangeListener("value", this.rootListener);
        this.root = this.rootHolder.getValue();
        if (this.root == null) {
            throw new NullPointerException();
        }
        this.engageNode(this.root);
        this.addRoot();
    }

    private void addRoot() {
        this.addNode(0, this.root);
    }

    private void disengageModel() {
        this.removeRoot();
        this.disengageNode(this.root);
        this.root = null;
        this.rootHolder.removePropertyChangeListener("value", this.rootListener);
    }

    private void removeRoot() {
        this.removeNode(0, this.root);
    }

    void rootChanged() {
        TreeNodeValueModel<T> newRoot = this.rootHolder.getValue();
        if (newRoot == null) {
            throw new NullPointerException();
        }
        this.removeRoot();
        TreeNodeValueModel<T> oldRoot = this.root;
        this.root = newRoot;
        this.engageNode(this.root);
        this.fireTreeRootReplaced(this.root);
        this.disengageNode(oldRoot);
        this.addRoot();
    }

    void nodeChanged(TreeNodeValueModel<T> node) {
        TreeNodeValueModel<T> parent = node.parent();
        if (parent == null) {
            this.fireTreeRootChanged(node);
        } else {
            this.fireTreeNodeChanged(parent.path(), parent.indexOfChild(node), node);
        }
    }

    void addChildren(TreeNodeValueModel<T>[] path, int[] childIndices, TreeNodeValueModel<T>[] children) {
        int len = childIndices.length;
        int i = 0;
        while (i < len) {
            this.engageNode(children[i]);
            ++i;
        }
        this.fireTreeNodesInserted(path, childIndices, children);
        i = 0;
        while (i < len) {
            this.addNode(childIndices[i], children[i]);
            ++i;
        }
    }

    private void engageNode(TreeNodeValueModel<T> node) {
        node.addStateChangeListener(this.nodeStateListener);
        node.addPropertyChangeListener("value", this.nodeValueListener);
        node.childrenModel().addListChangeListener("list values", this.childrenListener);
    }

    private void addNode(int index, TreeNodeValueModel<T> node) {
        this.addNodeToInternalTree(node.parent(), index, node, node.childrenModel());
        new NodeChangePolicy(node).addChildren();
    }

    private void addNodeToInternalTree(TreeNodeValueModel<T> parent, int index, TreeNodeValueModel<T> node, ListValueModel<TreeNodeValueModel<T>> childrenModel) {
        List<TreeNodeValueModel<T>> siblings = this.childrenLists.get(parent);
        if (siblings == null) {
            siblings = new ArrayList<TreeNodeValueModel<T>>();
            this.childrenLists.put(parent, siblings);
        }
        siblings.add(index, node);
        this.parents.put(childrenModel, node);
    }

    void removeChildren(TreeNodeValueModel<T>[] path, int[] childIndices, TreeNodeValueModel<T>[] children) {
        int len = childIndices.length;
        int i = 0;
        while (i < len) {
            this.removeNode(childIndices[i] - i, children[i]);
            ++i;
        }
        this.fireTreeNodesRemoved(path, childIndices, children);
        i = 0;
        while (i < len) {
            this.disengageNode(children[i]);
            ++i;
        }
    }

    private void removeNode(int index, TreeNodeValueModel<T> node) {
        new NodeChangePolicy(node).removeChildren();
        this.removeNodeFromInternalTree(node.parent(), index, node.childrenModel());
    }

    private void removeNodeFromInternalTree(TreeNodeValueModel<T> parent, int index, ListValueModel<TreeNodeValueModel<T>> childrenModel) {
        this.parents.remove(childrenModel);
        List<TreeNodeValueModel<T>> siblings = this.childrenLists.get(parent);
        siblings.remove(index);
        if (siblings.isEmpty()) {
            this.childrenLists.remove(parent);
        }
    }

    private void disengageNode(TreeNodeValueModel<T> node) {
        node.childrenModel().removeListChangeListener("list values", this.childrenListener);
        node.removePropertyChangeListener("value", this.nodeValueListener);
        node.removeStateChangeListener(this.nodeStateListener);
    }

    void moveChildren(TreeNodeValueModel<T> parent, int targetIndex, int sourceIndex, int length) {
        List<TreeNodeValueModel<T>> childrenList = this.childrenLists.get(parent);
        ArrayList<TreeNodeValueModel<T>> temp = new ArrayList<TreeNodeValueModel<T>>(length);
        int i = 0;
        while (i < length) {
            temp.add(childrenList.remove(sourceIndex));
            ++i;
        }
        childrenList.addAll(targetIndex, temp);
        this.fireTreeStructureChanged(parent.path());
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.root);
    }

    class AddEventChangePolicy
    extends EventChangePolicy {
        AddEventChangePolicy(ListAddEvent event) {
            super(event);
        }

        private ListAddEvent getEvent() {
            return (ListAddEvent)this.event;
        }

        @Override
        int childrenStartIndex() {
            return this.getEvent().getIndex();
        }

        @Override
        int childrenSize() {
            return this.getEvent().getItemsSize();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            return this.getEvent().getItems();
        }
    }

    class ChangeEventChangePolicy
    extends EventChangePolicy {
        ChangeEventChangePolicy(ListChangeEvent event) {
            super(event);
        }

        void rebuildChildren() {
            TreeNodeValueModel parent = this.parent();
            TreeNodeValueModel<T>[] parentPath = parent.path();
            List childrenList = TreeModelAdapter.this.childrenLists.get(parent);
            int[] childIndices = this.buildIndices(childrenList.size());
            TreeNodeValueModel<T>[] childArray = this.buildArray(childrenList, childrenList.size());
            TreeModelAdapter.this.removeChildren(parentPath, childIndices, childArray);
            childIndices = this.buildIndices(parent.childrenModel().size());
            childArray = this.buildArray(parent.childrenModel(), parent.childrenSize());
            TreeModelAdapter.this.addChildren(parentPath, childIndices, childArray);
        }

        @Override
        int childrenStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        int childrenSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class ChangePolicy {
        ChangePolicy() {
        }

        void addChildren() {
            TreeModelAdapter.this.addChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        void removeChildren() {
            TreeModelAdapter.this.removeChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        int[] childIndices() {
            return this.buildIndices(this.childrenStartIndex(), this.childrenSize());
        }

        TreeNodeValueModel<T>[] childArray() {
            return this.buildArray(this.getChildren(), this.childrenSize());
        }

        TreeNodeValueModel<T>[] buildArray(Iterable<TreeNodeValueModel<T>> elements, int size) {
            TreeNodeValueModel[] array = new TreeNodeValueModel[size];
            int i = 0;
            for (TreeNodeValueModel element : elements) {
                array[i++] = element;
            }
            return array;
        }

        int[] buildIndices(int size) {
            return this.buildIndices(0, size);
        }

        int[] buildIndices(int start, int size) {
            int[] indices = new int[size];
            int index = start;
            int i = 0;
            while (i < size) {
                indices[i] = index++;
                ++i;
            }
            return indices;
        }

        abstract TreeNodeValueModel<T> parent();

        abstract int childrenStartIndex();

        abstract int childrenSize();

        abstract Iterable<TreeNodeValueModel<T>> getChildren();
    }

    class ClearEventChangePolicy
    extends EventChangePolicy {
        ClearEventChangePolicy(ListClearEvent event) {
            super(event);
        }

        void clearChildren() {
            TreeNodeValueModel parent = this.parent();
            TreeNodeValueModel<T>[] parentPath = parent.path();
            List childrenList = TreeModelAdapter.this.childrenLists.get(parent);
            int[] childIndices = this.buildIndices(childrenList.size());
            TreeNodeValueModel<T>[] childArray = this.buildArray(childrenList, childrenList.size());
            TreeModelAdapter.this.removeChildren(parentPath, childIndices, childArray);
        }

        @Override
        int childrenStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        int childrenSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            throw new UnsupportedOperationException();
        }
    }

    abstract class EventChangePolicy
    extends ChangePolicy {
        final ListEvent event;

        EventChangePolicy(ListEvent event) {
            this.event = event;
        }

        @Override
        TreeNodeValueModel<T> parent() {
            return TreeModelAdapter.this.parents.get(this.event.getSource());
        }
    }

    class MoveEventChangePolicy
    extends EventChangePolicy {
        MoveEventChangePolicy(ListMoveEvent event) {
            super(event);
        }

        private ListMoveEvent getEvent() {
            return (ListMoveEvent)this.event;
        }

        void moveChildren() {
            TreeModelAdapter.this.moveChildren(this.parent(), this.getEvent().getTargetIndex(), this.getEvent().getSourceIndex(), this.getEvent().getLength());
        }

        @Override
        int childrenStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        int childrenSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            throw new UnsupportedOperationException();
        }
    }

    class NodeChangePolicy
    extends ChangePolicy {
        private final TreeNodeValueModel<T> node;

        NodeChangePolicy(TreeNodeValueModel<T> node) {
            this.node = node;
        }

        @Override
        TreeNodeValueModel<T> parent() {
            return this.node;
        }

        @Override
        int childrenStartIndex() {
            return 0;
        }

        @Override
        int childrenSize() {
            return this.node.childrenModel().size();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            return this.node.childrenModel();
        }
    }

    class RemoveEventChangePolicy
    extends EventChangePolicy {
        RemoveEventChangePolicy(ListRemoveEvent event) {
            super(event);
        }

        private ListRemoveEvent getEvent() {
            return (ListRemoveEvent)this.event;
        }

        @Override
        int childrenStartIndex() {
            return this.getEvent().getIndex();
        }

        @Override
        int childrenSize() {
            return this.getEvent().getItemsSize();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            return this.getEvent().getItems();
        }
    }

    class ReplaceEventChangePolicy
    extends EventChangePolicy {
        ReplaceEventChangePolicy(ListReplaceEvent event) {
            super(event);
        }

        private ListReplaceEvent getEvent() {
            return (ListReplaceEvent)this.event;
        }

        @Override
        int childrenStartIndex() {
            return this.getEvent().getIndex();
        }

        @Override
        int childrenSize() {
            return this.getEvent().getItemsSize();
        }

        @Override
        Iterable<TreeNodeValueModel<T>> getChildren() {
            return this.getEvent().getNewItems();
        }

        void replaceChildren() {
            TreeNodeValueModel<T>[] parentPath = this.parent().path();
            int[] childIndices = this.childIndices();
            TreeModelAdapter.this.removeChildren(parentPath, childIndices, this.getOldChildren());
            TreeModelAdapter.this.addChildren(parentPath, childIndices, this.childArray());
        }

        TreeNodeValueModel<T>[] getOldChildren() {
            return this.buildArray(this.getOldItems(), this.getEvent().getItemsSize());
        }

        protected Iterable<TreeNodeValueModel<T>> getOldItems() {
            return this.getEvent().getOldItems();
        }
    }
}

