/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.Element;

public final class XMLViewObjectMappingService
implements Serializable {
    private static final long serialVersionUID = -5371998199186683997L;
    private final Map<ElementData, ViewObject> _elementToViewObjMap = new HashMap<ElementData, ViewObject>();
    private final Map<ViewObject, ElementData> _viewObjToElementMap = new HashMap<ViewObject, ElementData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMapping(ElementData elementData, ViewObject viewObject) {
        if (elementData == null) {
            throw new IllegalArgumentException("elementData cannot be null");
        }
        if (viewObject == null) {
            throw new IllegalArgumentException("viewObject cannot be null");
        }
        XMLViewObjectMappingService xMLViewObjectMappingService = this;
        synchronized (xMLViewObjectMappingService) {
            this._elementToViewObjMap.put(elementData, viewObject);
            this._viewObjToElementMap.put(viewObject, elementData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMappings() {
        XMLViewObjectMappingService xMLViewObjectMappingService = this;
        synchronized (xMLViewObjectMappingService) {
            this._elementToViewObjMap.clear();
            this._viewObjToElementMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewObject removeMapping(ElementData elementData) {
        if (elementData == null) {
            throw new IllegalArgumentException("elementData mustn't be null");
        }
        ViewObject viewObject = null;
        XMLViewObjectMappingService xMLViewObjectMappingService = this;
        synchronized (xMLViewObjectMappingService) {
            viewObject = this._elementToViewObjMap.remove(elementData);
            if (viewObject != null) {
                this._viewObjToElementMap.remove(viewObject);
            }
        }
        return viewObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementData removeMapping(ViewObject viewObject) {
        if (viewObject == null) {
            throw new IllegalArgumentException("elementData mustn't be null");
        }
        ElementData elementData = null;
        XMLViewObjectMappingService xMLViewObjectMappingService = this;
        synchronized (xMLViewObjectMappingService) {
            elementData = this._viewObjToElementMap.remove(viewObject);
            if (elementData != null) {
                this._elementToViewObjMap.remove(elementData);
            }
        }
        return elementData;
    }

    public synchronized ElementData findElementData(ViewObject viewObject) {
        return this._viewObjToElementMap.get(viewObject);
    }

    public Element findElement(ViewObject viewObject) {
        IFile file;
        ElementData elementData = this.findElementData(viewObject);
        if (elementData != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(elementData.getDocumentPath()))) != null && file.isAccessible()) {
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                IStructuredDocument sDoc = model.getStructuredDocument();
                IStructuredDocumentRegion region = sDoc.getRegionAtCharacterOffset(elementData.getStartOffset());
                Region2ElementAdapter adapter = new Region2ElementAdapter((ITextRegion)region);
                TagIdentifier tagId = adapter.getTagId();
                if (tagId.equals((Object)elementData.getTagId())) {
                    Element element = adapter.getElement();
                    return element;
                }
            }
            catch (CoreException ce) {
                JSFCorePlugin.log((Exception)((Object)ce), "While finding element for viewObject: " + viewObject.toString() + " in " + file.getFullPath());
            }
            catch (IOException e) {
                JSFCorePlugin.log(e, "While finding element for viewObject: " + viewObject.toString() + " in " + file.getFullPath());
            }
            catch (Region2ElementAdapter.NoElementException e) {
                JSFCorePlugin.log(e, "While finding element for viewObject: " + viewObject.toString() + " in " + file.getFullPath());
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    public synchronized ViewObject findViewObject(ElementData elementData) {
        return this._elementToViewObjMap.get(elementData);
    }

    public static ElementData createElementData(String namespace, String tagName, IStructuredDocumentContext context, Map<String, String> attributeToPropertyMap) {
        IFile file = XMLViewObjectMappingService.getFile(context);
        int offset = context.getDocumentPosition();
        if (file != null && file.isAccessible() && offset > -1 && tagName != null && namespace != null) {
            return new ElementData(offset, file.getFullPath().toString(), TagIdentifierFactory.createJSPTagWrapper(namespace, tagName), attributeToPropertyMap);
        }
        return null;
    }

    private static IFile getFile(IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        IResource res = resolver.getResource();
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public static final class ElementData
    implements Serializable {
        private static final long serialVersionUID = 7937312530318827977L;
        private transient TagIdentifier _tagId;
        private Map<String, String> _attributeToPropertyMap;
        private String _documentPath;
        private int _startOffset;

        private ElementData(int startOffset, String documentPath, TagIdentifier tagId, Map<String, String> attributeToPropertyMap) {
            this._startOffset = startOffset;
            this._tagId = tagId;
            this._documentPath = documentPath;
            this._attributeToPropertyMap = Collections.unmodifiableMap(new HashMap<String, String>(attributeToPropertyMap));
        }

        protected ElementData() {
        }

        public final TagIdentifier getTagId() {
            return this._tagId;
        }

        public final String getPropertyName(String forTagAttribute) {
            return this._attributeToPropertyMap.get(forTagAttribute);
        }

        final int getStartOffset() {
            return this._startOffset;
        }

        final String getDocumentPath() {
            return this._documentPath;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this._tagId.getUri());
            out.writeObject(this._tagId.getTagName());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            String uri = (String)in.readObject();
            String tagName = (String)in.readObject();
            this._tagId = TagIdentifierFactory.createJSPTagWrapper(uri, tagName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ElementData) {
                ElementData other = (ElementData)obj;
                return this._startOffset == other._startOffset && this._documentPath.equals(other._documentPath) && this._tagId.equals((Object)other._tagId);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this._tagId.hashCode();
            hashCode ^= this._documentPath.hashCode();
            return hashCode ^= ~(this._startOffset * 104551);
        }
    }
}

