/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.BindingType;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebServiceProviderRules
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebServiceProvider.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof ClassDeclaration)) continue;
            this.checkForDefaultConstructor((ClassDeclaration)declaration);
            this.checkForProviderInterface((ClassDeclaration)declaration);
        }
    }

    private void checkForProviderInterface(ClassDeclaration classDeclaration) {
        Collection interfaces = classDeclaration.getSuperinterfaces();
        boolean implementsTypedProvider = false;
        if (interfaces.size() > 0) {
            block0: for (InterfaceType interfaceType : interfaces) {
                Collection typeParameters = interfaceType.getActualTypeArguments();
                if (typeParameters.size() <= 0) continue;
                for (TypeMirror typeMirror : typeParameters) {
                    if (typeMirror instanceof ClassDeclaration) {
                        ClassDeclaration classDecl = (ClassDeclaration)typeMirror;
                        if (classDecl.getQualifiedName().equals(SOAPMessage.class.getCanonicalName())) {
                            this.checkSOAPMessageRequirements(classDeclaration);
                            implementsTypedProvider = true;
                            continue block0;
                        }
                        Collection implementedInterfaces = classDecl.getSuperinterfaces();
                        for (InterfaceType implementedInterface : implementedInterfaces) {
                            InterfaceDeclaration interfaceDecl = implementedInterface.getDeclaration();
                            if (interfaceDecl == null) continue;
                            if (interfaceDecl.getQualifiedName().equals(Source.class.getCanonicalName())) {
                                implementsTypedProvider = true;
                                break;
                            }
                            if (!interfaceDecl.getQualifiedName().equals(DataSource.class.getCanonicalName())) continue;
                            this.checkDataSourceRequirements(classDeclaration);
                            implementsTypedProvider = true;
                            break;
                        }
                    }
                    if (!(typeMirror instanceof InterfaceDeclaration)) continue;
                    InterfaceDeclaration interfaceDecl = (InterfaceDeclaration)typeMirror;
                    if (interfaceDecl.getQualifiedName().equals(Source.class.getCanonicalName())) {
                        implementsTypedProvider = true;
                        continue block0;
                    }
                    if (!interfaceDecl.getQualifiedName().equals(DataSource.class.getCanonicalName())) continue;
                    this.checkDataSourceRequirements(classDeclaration);
                    implementsTypedProvider = true;
                    continue block0;
                }
            }
        }
        if (!implementsTypedProvider) {
            AnnotationMirror webServiceProvider = AnnotationUtils.getAnnotation((Declaration)classDeclaration, WebServiceProvider.class);
            this.printFixableError(webServiceProvider.getPosition(), JAXWSCoreMessages.WEBSERVICEPROVIDER_IMPLEMENT_TYPED_PROVIDER_INTERFACE);
        }
    }

    private void checkSOAPMessageRequirements(ClassDeclaration classDeclaration) {
        if (!this.isSOAPBinding(classDeclaration)) {
            this.printError(classDeclaration.getPosition(), JAXWSCoreMessages.WEBSERVICEPROVIDER_SOAPMESSAGE_SOAPBINDING);
        }
        if (!this.isMessageMode(classDeclaration)) {
            this.printError(classDeclaration.getPosition(), JAXWSCoreMessages.WEBSERVICEPROVIDER_SOAPMESSAGE_MESSAGE_MODE);
        }
    }

    private void checkDataSourceRequirements(ClassDeclaration classDeclaration) {
        if (!this.isHTTPBinding(classDeclaration)) {
            this.printError(classDeclaration.getPosition(), JAXWSCoreMessages.WEBSERVICEPROVIDER_DATASOURCE_HTTPBINDING);
        }
        if (!this.isMessageMode(classDeclaration)) {
            this.printError(classDeclaration.getPosition(), JAXWSCoreMessages.WEBSERVICEPROVIDER_DATASOURCE_MESSAGE_MODE);
        }
    }

    private boolean isSOAPBinding(ClassDeclaration classDeclaration) {
        String bindingType = this.getBindingTypeValue(classDeclaration);
        return bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
    }

    private boolean isHTTPBinding(ClassDeclaration classDeclaration) {
        String bindingType = this.getBindingTypeValue(classDeclaration);
        return bindingType.equals("http://www.w3.org/2004/08/wsdl/http");
    }

    private String getBindingTypeValue(ClassDeclaration classDeclaration) {
        String value;
        AnnotationMirror bindingType = AnnotationUtils.getAnnotation((Declaration)classDeclaration, BindingType.class);
        if (bindingType != null && (value = AnnotationUtils.getStringValue((AnnotationMirror)bindingType, (String)"value")) != null) {
            return value;
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    private boolean isMessageMode(ClassDeclaration classDeclaration) {
        return this.getServiceMode(classDeclaration).equals(Service.Mode.MESSAGE.name());
    }

    private boolean isPayloadMode(ClassDeclaration classDeclaration) {
        return this.getServiceMode(classDeclaration).equals(Service.Mode.PAYLOAD.name());
    }

    private String getServiceMode(ClassDeclaration classDeclaration) {
        String value;
        AnnotationMirror serviceMode = AnnotationUtils.getAnnotation((Declaration)classDeclaration, ServiceMode.class);
        if (serviceMode != null && (value = AnnotationUtils.getStringValue((AnnotationMirror)serviceMode, (String)"value")) != null) {
            return value;
        }
        return Service.Mode.PAYLOAD.toString();
    }

    private void checkForDefaultConstructor(ClassDeclaration classDeclaration) {
        boolean hasDefaultConstructor = false;
        Collection constructors = classDeclaration.getConstructors();
        if (constructors.size() == 0) {
            hasDefaultConstructor = true;
        } else {
            for (ConstructorDeclaration constructorDeclaration : constructors) {
                if (!constructorDeclaration.getModifiers().contains(Modifier.PUBLIC) || constructorDeclaration.getParameters().size() != 0) continue;
                hasDefaultConstructor = true;
                break;
            }
        }
        if (!hasDefaultConstructor) {
            AnnotationMirror webServiceProvider = AnnotationUtils.getAnnotation((Declaration)classDeclaration, WebServiceProvider.class);
            this.printFixableError(webServiceProvider.getPosition(), JAXWSCoreMessages.WEBSERVICEPROVIDER_DEFAULT_PUBLIC_CONSTRUCTOR);
        }
    }
}

