/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.cdt.libhover.ClassInfo;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.cdt.libhover.TypedefInfo;
import org.osgi.framework.Bundle;

public class LibHoverLibrary {
    private String name;
    private String location;
    private String docs;
    private String nameSpace;
    private boolean isCPP;
    private LibHoverInfo hoverInfo = new LibHoverInfo();
    private boolean haveReadHoverInfo = false;

    public LibHoverLibrary(String name, String location, String docs, String nameSpace, boolean isCPP) {
        this.name = name;
        this.location = location;
        this.docs = docs;
        this.isCPP = isCPP;
        this.nameSpace = nameSpace;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDocs() {
        return this.docs;
    }

    public void setDocs(String docs) {
        this.docs = docs;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public boolean isCPP() {
        return this.isCPP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized LibHoverInfo getHoverInfo() {
        if (this.haveReadHoverInfo) return this.hoverInfo;
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try {
                InputStream docStream = this.getDocStreamForHoverInfo();
                try {
                    try (ObjectInputStream input = new ObjectInputStream(docStream);){
                        this.hoverInfo = (LibHoverInfo)input.readObject();
                        this.haveReadHoverInfo = true;
                    }
                    if (docStream == null) return this.hoverInfo;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (docStream == null) throw throwable;
                    docStream.close();
                    throw throwable;
                }
                docStream.close();
                return this.hoverInfo;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException | MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            return this.hoverInfo;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.hoverInfo;
    }

    private InputStream getDocStreamForHoverInfo() throws URISyntaxException, IOException {
        URI acDoc = new URI(this.location);
        IPath p = URIUtil.toPath((URI)acDoc);
        if (p == null) {
            URL url = acDoc.toURL();
            URLConnection c = url.openConnection();
            c.setReadTimeout(5000);
            return c.getInputStream();
        }
        Bundle bundle = LibhoverPlugin.getDefault().getBundle();
        String nameSpace = this.getNameSpace();
        if (nameSpace != null) {
            bundle = Platform.getBundle((String)nameSpace);
        }
        try {
            return FileLocator.openStream((Bundle)bundle, (IPath)p, (boolean)false);
        }
        catch (IOException e) {
            return new FileInputStream(p.toFile());
        }
    }

    public synchronized void setHoverinfo(LibHoverInfo hoverInfo) {
        this.hoverInfo = hoverInfo;
    }

    public ClassInfo getClassInfo(String className, ArrayList<String> templateTypes) {
        int index;
        String typedefName = className.replaceAll("<.*>", "<>");
        TypedefInfo typedef = this.getHoverInfo().typedefs.get(typedefName);
        if (typedef != null) {
            className = typedef.getTransformedType(className);
        }
        if ((index = className.indexOf(60)) != -1) {
            ArrayList<ClassInfo> children;
            this.resolveTemplateTypes(className, templateTypes, index);
            ClassInfo info = this.getHoverInfo().classes.get(className.substring(0, index));
            if (info != null && (children = info.getChildren()) != null && children.size() > 0) {
                int x = 0;
                while (x < children.size()) {
                    ClassInfo child = children.get(x);
                    if (className.matches(child.getClassName())) {
                        info = child;
                        break;
                    }
                    ++x;
                }
            }
            return info;
        }
        return this.getHoverInfo().classes.get(className);
    }

    private void resolveTemplateTypes(String className, ArrayList<String> templateTypes, int index) {
        int startIndex;
        int i = startIndex = index + 1;
        int count = 1;
        while (count > 0 && i < className.length()) {
            char x = className.charAt(i);
            switch (x) {
                case '<': {
                    ++count;
                    break;
                }
                case '>': {
                    if (--count != 0) break;
                    templateTypes.add(className.substring(startIndex, i).trim());
                    break;
                }
                case ',': {
                    if (count != 1) break;
                    templateTypes.add(className.substring(startIndex, i).trim());
                    startIndex = i + 1;
                }
            }
            ++i;
        }
    }

    public FunctionInfo getFunctionInfo(String name) {
        return this.getHoverInfo().functions.get(name);
    }
}

