/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view.fields;

import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTDataViewersField;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.parser.HistogramDecoder;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistFile;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistLine;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;
import org.eclipse.swt.graphics.Color;

public class SampleProfField
extends AbstractSTDataViewersField
implements IChartField {
    private boolean samples = true;
    protected final AbstractSTTreeViewer viewer;
    protected static final double UNINITIALIZED = 0.0;

    public SampleProfField(AbstractSTTreeViewer viewer) {
        this.viewer = viewer;
    }

    public int compare(Object obj1, Object obj2) {
        TreeElement e1 = (TreeElement)obj1;
        TreeElement e2 = (TreeElement)obj2;
        int s1 = e1.getSamples();
        int s2 = e2.getSamples();
        return s1 - s2;
    }

    public String getColumnHeaderText() {
        if (this.samples) {
            return Messages.SampleProfField_SAMPLE_HDR;
        }
        return Messages.SampleProfField_TIME_HDR;
    }

    public String getColumnHeaderTooltip() {
        return null;
    }

    public String getValue(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getSamples();
        if (i == -1) {
            return "";
        }
        if (this.samples) {
            return String.valueOf(i);
        }
        double prof_rate = this.getProfRate();
        if (prof_rate == 0.0) {
            return "?";
        }
        return SampleProfField.getValue(i, prof_rate);
    }

    public static String getValue(double i, double profRate) {
        long timeInNs = (long)(i / profRate);
        long ns = timeInNs % 1000L;
        long timeInUs = timeInNs / 1000L;
        if (timeInUs == 0L) {
            return String.valueOf(ns) + "ns";
        }
        long us = timeInUs % 1000L;
        long timeInMs = timeInUs / 1000L;
        if (timeInMs == 0L) {
            String ns_s = "" + ns;
            while (ns_s.length() < 3) {
                ns_s = "0" + ns_s;
            }
            return String.valueOf(us) + "." + ns_s + "us";
        }
        long ms = timeInMs % 1000L;
        long timeInS = timeInMs / 1000L;
        if (timeInS == 0L) {
            String us_s = "" + us;
            while (us_s.length() < 3) {
                us_s = "0" + us_s;
            }
            return String.valueOf(ms) + "." + us_s + "ms";
        }
        long s = timeInS % 60L;
        long timeInMin = timeInS / 60L;
        if (timeInMin == 0L) {
            String ms_s = "" + ms;
            while (ms_s.length() < 3) {
                ms_s = "0" + ms_s;
            }
            return String.valueOf(s) + "." + ms_s + "s";
        }
        long min = timeInMin % 60L;
        long timeInHour = timeInMin / 60L;
        if (timeInHour == 0L) {
            return String.valueOf(min) + "min " + s + "s";
        }
        return String.valueOf(timeInHour) + "h " + min + "min";
    }

    /*
     * WARNING - void declaration
     */
    protected double getProfRate() {
        double prof_rate = 0.0;
        Object o = this.viewer.getViewer().getInput();
        Object object = o;
        if (object instanceof GmonDecoder) {
            void decoder;
            GmonDecoder gmonDecoder = (GmonDecoder)object;
            GmonDecoder cfr_ignored_0 = (GmonDecoder)object;
            HistogramDecoder histo = decoder.getHistogramDecoder();
            prof_rate = histo.getProfRate();
            char tUnit = histo.getTimeDimension();
            switch (tUnit) {
                case 's': {
                    prof_rate /= 1.0E9;
                    break;
                }
                case 'm': {
                    prof_rate /= 1000000.0;
                    break;
                }
                case 'u': {
                    prof_rate /= 1000.0;
                }
            }
        }
        return prof_rate;
    }

    public Color getBackground(Object element) {
        return GmonView.getBackground(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof HistRoot) {
            return Messages.SampleProfField_TOTAL_TIME_SPENT;
        }
        if (element instanceof HistFunction) {
            return Messages.SampleProfField_TIME_SPENT_IN_FUNCTION;
        }
        if (element instanceof HistFile) {
            return Messages.SampleProfField_TIME_SPENT_IN_FILE;
        }
        if (element instanceof HistLine) {
            return Messages.SampleProfField_TIME_SPENT_AT_LOCATION;
        }
        return null;
    }

    public void toggle() {
        this.samples = !this.samples;
    }

    public Number getNumber(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getSamples();
        if (i == -1) {
            return 0L;
        }
        return i;
    }
}

