/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenMessageDialog;
import org.eclipse.m2e.core.ui.internal.util.Util;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormUtils {
    private static final Logger log = LoggerFactory.getLogger(FormUtils.class);
    public static final int MAX_MSG_LENGTH = 80;

    public static void decorateHeader(FormToolkit toolkit, Form form) {
        ((FormTooliktStub)Util.proxy((Object)toolkit, FormTooliktStub.class)).decorateFormHeading(form);
    }

    public static boolean setMessage(ScrolledForm form, String message, int severity) {
        if (message != null && (message.length() > 80 || message.contains("\n"))) {
            String truncMsg = message;
            String[] lines = message.split("\n");
            truncMsg = lines.length > 0 ? lines[0] : message.substring(0, 80);
            FormUtils.setMessageAndTTip(form, NLS.bind((String)Messages.FormUtils_click_for_details, (Object)truncMsg), message, severity);
            return true;
        }
        FormUtils.setMessageAndTTip(form, message, message, severity);
        return false;
    }

    public static void setMessageAndTTip(ScrolledForm form, String message, String ttip, int severity) {
        if (form.isDisposed()) {
            return;
        }
        form.getForm().setMessage(message, severity);
        FormUtils.addFormTitleListeners(FormUtils.createDefaultPerformer(form, message, ttip, severity), form);
    }

    static void setMessageWithPerformer(ScrolledForm form, String message, int severity, Consumer<Point> runnable) {
        form.getForm().setMessage(message, severity);
        FormUtils.addFormTitleListeners(runnable, form);
    }

    public static String nvl(String s) {
        return s == null ? "" : s;
    }

    public static String nvl(String s, String defaultValue) {
        return s == null ? defaultValue : s;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(Text t) {
        return t == null || FormUtils.isEmpty(t.getText());
    }

    public static void setText(Text control, String text) {
        if (control != null && !control.isDisposed() && !control.getText().equals(text)) {
            control.setText(FormUtils.nvl(text));
            control.setSelection(FormUtils.nvl(text).length());
        }
    }

    public static void setText(CCombo control, String text) {
        if (control != null && !control.isDisposed() && !control.getText().equals(text)) {
            control.setText(FormUtils.nvl(text));
        }
    }

    public static void setButton(Button control, boolean selection) {
        if (control != null && !control.isDisposed() && control.getSelection() != selection) {
            control.setSelection(selection);
        }
    }

    public static void openHyperlink(String url) {
        if (!FormUtils.isEmpty(url) && (url.startsWith("http://") || url.startsWith("https://"))) {
            url = url.trim();
            try {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser browser = browserSupport.createBrowser(6, url, url, url);
                browser.openURL(new URL(url));
            }
            catch (PartInitException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            catch (MalformedURLException ex) {
                log.error("Malformed url " + url, (Throwable)ex);
            }
        }
    }

    public static void setEnabled(Composite composite, boolean enabled) {
        if (composite != null && !composite.isDisposed()) {
            composite.setEnabled(enabled);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Combo) {
                    control.setEnabled(enabled);
                } else if (control instanceof CCombo) {
                    control.setEnabled(enabled);
                } else if (control instanceof Hyperlink) {
                    control.setEnabled(enabled);
                } else if (control instanceof Composite) {
                    FormUtils.setEnabled((Composite)control, enabled);
                } else {
                    control.setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    static void setReadonly(Composite composite, boolean readonly) {
        if (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Text var6_6) {
                    text.setEditable(!readonly);
                } else {
                    if (control instanceof Combo var9_8) {
                        combo.setEnabled(!readonly);
                    } else {
                        if (control instanceof CCombo var12_10) {
                            ccombo.setEnabled(!readonly);
                        } else {
                            if (control instanceof Button var15_12) {
                                button.setEnabled(!readonly);
                            } else {
                                if (control instanceof Composite var18_14) {
                                    FormUtils.setReadonly((Composite)c, readonly);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static void cleanupMouseListeners(Control kid, int event) {
        Listener[] listeners = kid.getListeners(event);
        if (listeners != null) {
            Listener[] listenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener list = listenerArray[n2];
                kid.removeListener(event, list);
                ++n2;
            }
        }
    }

    private static Consumer<Point> createDefaultPerformer(ScrolledForm form, String message, String ttip, int severity) {
        if (ttip != null && ttip.length() > 0 && message != null) {
            return point -> {
                int dialogSev = 3 == severity ? 1 : 4;
                MavenMessageDialog.openWithSeverity((Shell)form.getShell(), (String)Messages.FormUtils_error_info, (String)Messages.FormUtils_pom_error, (String)ttip, (int)dialogSev);
            };
        }
        return null;
    }

    private static void addFormTitleListeners(final Consumer<Point> runnable, ScrolledForm form) {
        if (runnable != null) {
            Control[] kids;
            final Composite head = form.getForm().getHead();
            Control[] controlArray = kids = head.getChildren();
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                final Control kid = controlArray[n2];
                if (kid != form && kid instanceof Canvas) {
                    FormUtils.cleanupMouseListeners(kid, 4);
                    FormUtils.cleanupMouseListeners(kid, 6);
                    FormUtils.cleanupMouseListeners(kid, 7);
                    kid.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseUp(MouseEvent e) {
                            runnable.accept(kid.toDisplay(new Point(e.x, e.y)));
                        }
                    });
                    kid.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                        public void mouseEnter(MouseEvent e) {
                            head.setCursor(Display.getDefault().getSystemCursor(21));
                        }

                        public void mouseExit(MouseEvent e) {
                            head.setCursor(null);
                        }
                    });
                }
                ++n2;
            }
        } else {
            Control[] kids;
            Composite head = form.getForm().getHead();
            Control[] controlArray = kids = head.getChildren();
            int n = kids.length;
            int n3 = 0;
            while (n3 < n) {
                Control kid = controlArray[n3];
                if (kid != form && kid instanceof Canvas) {
                    FormUtils.cleanupMouseListeners(kid, 4);
                    FormUtils.cleanupMouseListeners(kid, 6);
                    FormUtils.cleanupMouseListeners(kid, 7);
                }
                ++n3;
            }
        }
    }

    static String simpleInterpolate(MavenProject project, String text) {
        if (text != null && text.contains("${")) {
            if (project == null) {
                return null;
            }
            Properties props = project.getProperties();
            RegexBasedInterpolator inter = new RegexBasedInterpolator();
            if (props != null) {
                inter.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
            }
            inter.addValueSource((ValueSource)new PrefixedObjectValueSource(Arrays.asList("pom.", "project."), (Object)project.getModel(), false));
            try {
                text = inter.interpolate(text);
            }
            catch (InterpolationException e) {
                text = null;
            }
        }
        return text;
    }

    private static interface FormTooliktStub {
        public void decorateFormHeading(Form var1);
    }
}

