/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.m2m.internal.qvt.oml.TransformationRunner;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugRunnerFactory;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugTransformationRunner;
import org.eclipse.m2m.qvt.oml.debug.core.app.QVTOApplication;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMInitializer;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMServer;
import org.eclipse.m2m.qvt.oml.debug.core.launch.TransformationRunnerFactory;

public class QVTODebugApplication
extends QVTOApplication {
    public static final String ID = "org.eclipse.m2m.qvt.oml.debug.core.QVTODebugApplication";
    public static final String ARG_PORT = "-port";
    private static final int PORT_UNDEFINED = -1;
    private int fPort = -1;

    @Override
    protected int doRun(TransformationRunner runner) {
        DebugTransformationRunner dbgRunner = (DebugTransformationRunner)runner;
        dbgRunner.setErrorLog(new PrintWriter(System.err, true));
        VMInitializer vmProvider = new VMInitializer(dbgRunner, this.getExecutionContext());
        vmProvider.startBackgrouInitialization();
        try {
            VMServer server = new VMServer(this.fPort, vmProvider);
            return server.run();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    protected boolean processCommandLineArg(String nextArg) {
        if (QVTODebugApplication.isValueSpecArg(ARG_PORT, nextArg)) {
            String val = QVTODebugApplication.getArgValue(ARG_PORT, nextArg);
            try {
                this.fPort = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid port specified: " + nextArg);
                return false;
            }
            return true;
        }
        return super.processCommandLineArg(nextArg);
    }

    @Override
    protected TransformationRunnerFactory createRunnerFactory() {
        return new DebugRunnerFactory();
    }

    @Override
    protected String getCommandLineUsage() {
        return String.valueOf(super.getCommandLineUsage()) + " " + QVTODebugApplication.squareBracket(ARG_PORT);
    }

    private static String squareBracket(String str) {
        return "[" + str + "]";
    }
}

