/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.IExportFormatter;
import org.eclipse.nebula.widgets.nattable.export.IExporter;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.ITableExporter;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaEvaluationCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.AutoResizeHelper;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.ui.ExceptionDialog;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class NatExporter {
    private static final Log LOG = LogFactory.getLog(NatExporter.class);
    protected final Shell shell;
    protected boolean openResult = true;
    protected boolean exportSucceeded = true;
    protected boolean preRender = true;

    public NatExporter(Shell shell) {
        this.shell = shell;
    }

    public void exportSingleLayer(ILayer layer, IConfigRegistry configRegistry) {
        ILayerExporter exporter = configRegistry.getConfigAttribute(ExportConfigAttributes.EXPORTER, "NORMAL", new String[0]);
        this.exportSingleLayer(exporter, layer, configRegistry);
    }

    public void exportSingleLayer(ILayerExporter exporter, final ILayer layer, final IConfigRegistry configRegistry) {
        this.exportSingle(exporter, new BiConsumer<ILayerExporter, OutputStream>(){

            @Override
            public void apply(ILayerExporter exporter, OutputStream outputStream) {
                try {
                    exporter.exportBegin(outputStream);
                    NatExporter.this.exportLayer(exporter, outputStream, "", layer, configRegistry);
                    exporter.exportEnd(outputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void exportSingleTable(ILayer layer, IConfigRegistry configRegistry) {
        ITableExporter exporter = configRegistry.getConfigAttribute(ExportConfigAttributes.TABLE_EXPORTER, "NORMAL", new String[0]);
        this.exportSingleTable(exporter, layer, configRegistry);
    }

    public void exportSingleTable(ITableExporter exporter, final ILayer layer, final IConfigRegistry configRegistry) {
        this.exportSingle(exporter, new BiConsumer<ITableExporter, OutputStream>(){

            @Override
            public void apply(ITableExporter exporter, OutputStream outputStream) {
                NatExporter.this.exportLayer(exporter, outputStream, layer, configRegistry);
            }
        });
    }

    private <T extends IExporter> void exportSingle(final T exporter, final BiConsumer<T, OutputStream> executable) {
        final OutputStream outputStream = this.getOutputStream(exporter);
        if (outputStream == null) {
            return;
        }
        Runnable exportRunnable = new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        try {
                            executable.apply(exporter, outputStream);
                            NatExporter.this.exportSucceeded = true;
                        }
                        catch (Exception e) {
                            NatExporter.this.exportSucceeded = false;
                            NatExporter.this.handleExportException(e);
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                LOG.error((Object)"Failed to close the output stream", (Throwable)e2);
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Failed to close the output stream", (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Failed to close the output stream", (Throwable)e);
                    }
                }
                NatExporter.this.openExport(exporter);
            }
        };
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(exportRunnable);
        } else {
            exportRunnable.run();
        }
    }

    public void exportMultipleNatTables(ILayerExporter exporter, Map<String, NatTable> natTablesMap) {
        this.exportMultipleNatTables(exporter, natTablesMap, false, null);
    }

    public void exportMultipleNatTables(final ILayerExporter exporter, final Map<String, NatTable> natTablesMap, final boolean exportOnSameSheet, final String sheetName) {
        final OutputStream outputStream = this.getOutputStream(exporter);
        if (outputStream == null) {
            return;
        }
        Runnable exportRunnable = new Runnable(){

            @Override
            public void run() {
                block14: {
                    try {
                        try {
                            exporter.exportBegin(outputStream);
                            if (exportOnSameSheet) {
                                exporter.exportLayerBegin(outputStream, sheetName);
                            }
                            for (String name : natTablesMap.keySet()) {
                                NatTable natTable = (NatTable)natTablesMap.get(name);
                                NatExporter.this.exportLayer(exporter, outputStream, name, natTable, natTable.getConfigRegistry(), !exportOnSameSheet);
                            }
                            if (exportOnSameSheet) {
                                exporter.exportLayerEnd(outputStream, sheetName);
                            }
                            exporter.exportEnd(outputStream);
                            NatExporter.this.exportSucceeded = true;
                        }
                        catch (Exception e) {
                            NatExporter.this.exportSucceeded = false;
                            NatExporter.this.handleExportException(e);
                            try {
                                outputStream.close();
                            }
                            catch (IOException e2) {
                                LOG.error((Object)"Failed to close the output stream", (Throwable)e2);
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Failed to close the output stream", (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Failed to close the output stream", (Throwable)e);
                    }
                }
                NatExporter.this.openExport(exporter);
            }
        };
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(exportRunnable);
        } else {
            exportRunnable.run();
        }
    }

    protected void exportLayer(ILayerExporter exporter, OutputStream outputStream, String layerName, ILayer layer, IConfigRegistry configRegistry) {
        this.exportLayer(exporter, outputStream, layerName, layer, configRegistry, true);
    }

    protected void exportLayer(final ILayerExporter exporter, OutputStream outputStream, final String layerName, ILayer layer, IConfigRegistry configRegistry, final boolean initExportLayer) {
        this.exportLayer(new ITableExporter(){

            @Override
            public void exportTable(Shell shell, ProgressBar progressBar, OutputStream outputStream, ILayer layer, IConfigRegistry configRegistry) throws IOException {
                if (initExportLayer) {
                    exporter.exportLayerBegin(outputStream, layerName);
                }
                int rowPosition = 0;
                while (rowPosition < layer.getRowCount()) {
                    exporter.exportRowBegin(outputStream, rowPosition);
                    if (progressBar != null) {
                        progressBar.setSelection(rowPosition);
                    }
                    int columnPosition = 0;
                    while (columnPosition < layer.getColumnCount()) {
                        ILayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
                        IExportFormatter exportFormatter = configRegistry.getConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
                        Object exportDisplayValue = exportFormatter.formatForExport(cell, configRegistry);
                        exporter.exportCell(outputStream, exportDisplayValue, cell, configRegistry);
                        ++columnPosition;
                    }
                    exporter.exportRowEnd(outputStream, rowPosition);
                    ++rowPosition;
                }
                if (initExportLayer) {
                    exporter.exportLayerEnd(outputStream, layerName);
                }
            }

            @Override
            public OutputStream getOutputStream(Shell shell) {
                return exporter.getOutputStream(shell);
            }

            @Override
            public Object getResult() {
                return exporter.getResult();
            }
        }, outputStream, layer, configRegistry);
    }

    protected void exportLayer(ITableExporter exporter, OutputStream outputStream, ILayer layer, IConfigRegistry configRegistry) {
        if (this.preRender) {
            AutoResizeHelper.autoResize(layer, configRegistry);
        }
        IClientAreaProvider originalClientAreaProvider = layer.getClientAreaProvider();
        layer.doCommand(new TurnViewportOffCommand());
        this.setClientAreaToMaximum(layer);
        layer.doCommand(new CalculateSummaryRowValuesCommand());
        layer.doCommand(new DisableFormulaEvaluationCommand());
        ProgressBar progressBar = null;
        if (this.shell != null) {
            Shell childShell = new Shell(this.shell.getDisplay(), 67680);
            childShell.setText(Messages.getString("NatExporter.exporting"));
            int endRow = layer.getRowCount() - 1;
            progressBar = new ProgressBar((Composite)childShell, 65536);
            progressBar.setMinimum(0);
            progressBar.setMaximum(endRow);
            progressBar.setBounds(0, 0, 400, 25);
            progressBar.setFocus();
            childShell.pack();
            childShell.open();
        }
        try {
            try {
                exporter.exportTable(this.shell, progressBar, outputStream, layer, configRegistry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            layer.setClientAreaProvider(originalClientAreaProvider);
            layer.doCommand(new TurnViewportOnCommand());
            layer.doCommand(new EnableFormulaEvaluationCommand());
            if (progressBar != null) {
                Shell childShell = progressBar.getShell();
                progressBar.dispose();
                childShell.dispose();
            }
        }
    }

    protected void setClientAreaToMaximum(ILayer layer) {
        final Rectangle maxClientArea = new Rectangle(0, 0, layer.getWidth(), layer.getHeight());
        layer.setClientAreaProvider(new IClientAreaProvider(){

            @Override
            public Rectangle getClientArea() {
                return maxClientArea;
            }
        });
        layer.doCommand(new PrintEntireGridCommand());
    }

    protected void openExport(IExporter exporter) {
        if (this.exportSucceeded && this.openResult && exporter.getResult() != null && exporter.getResult() instanceof File) {
            Program.launch((String)((File)exporter.getResult()).getAbsolutePath());
        }
    }

    public void setOpenResult(boolean openResult) {
        this.openResult = openResult;
    }

    protected OutputStream getOutputStream(IExporter exporter) {
        OutputStream outputStream = null;
        try {
            outputStream = exporter.getOutputStream(this.shell);
        }
        catch (Exception e) {
            this.handleExportException(e);
        }
        return outputStream;
    }

    protected void handleExportException(Exception e) {
        LOG.error((Object)"Failed to export.", (Throwable)e);
        ExceptionDialog.open(this.shell, Messages.getString("ErrorDialog.title"), Messages.getString("NatExporter.errorMessagePrefix", e.getLocalizedMessage()), e);
    }

    public void enablePreRendering() {
        this.preRender = true;
    }

    public void disablePreRendering() {
        this.preRender = false;
    }

    private static interface BiConsumer<T, U> {
        public void apply(T var1, U var2);
    }
}

