/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui;

import java.net.URL;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DebugVMUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ocl.examples.debug.vm.ui";
    private static DebugVMUIPlugin plugin;
    private static final Logger logger;
    protected ImageRegistry imageDescriptorRegistry;

    static {
        logger = Logger.getLogger(DebugVMUIPlugin.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.imageDescriptorRegistry != null) {
            this.imageDescriptorRegistry.dispose();
            this.imageDescriptorRegistry = null;
        }
        super.stop(context);
    }

    public static DebugVMUIPlugin getDefault() {
        return plugin;
    }

    public Image createImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            try {
                ImageDescriptor imageDescriptor = this.getImageDescriptor(path);
                if (imageDescriptor != null && (image = this.getImageDescriptor(path).createImage()) != null) {
                    this.getImageRegistry().put(path, image);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to createImage '" + path + "'"), (Throwable)e);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        URL url;
        ImageDescriptor imageDescriptor = this.getImageDescriptorRegistry().getDescriptor(path);
        if (imageDescriptor == null && (url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(path), Collections.emptyMap())) != null && (imageDescriptor = ImageDescriptor.createFromURL((URL)url)) != null) {
            this.getImageDescriptorRegistry().put(path, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected ImageRegistry getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = this.createImageRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public static BasicDiagnostic createDiagnostic(String message) {
        return new BasicDiagnostic(0, PLUGIN_ID, 0, message, null);
    }

    public static Diagnostic createErrorDiagnostic(String message, Throwable throwable) {
        Object[] objectArray;
        if (throwable == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = throwable;
        }
        Object[] data = objectArray;
        return new BasicDiagnostic(4, PLUGIN_ID, 0, message, data);
    }

    public static Diagnostic createWarnDiagnostic(String message) {
        return new BasicDiagnostic(4, PLUGIN_ID, 0, message, null);
    }

    public static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity != 4 && severity != 8;
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? "" : message;
        try {
            if (DebugVMUIPlugin.getDefault() != null) {
                DebugVMUIPlugin.log((IStatus)new Status(severity, PLUGIN_ID, code, msg, throwable));
            } else {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public static void log(IStatus status) {
        DebugVMUIPlugin debugPlugin = DebugVMUIPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        DebugVMUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, "Exception caught", e));
    }

    public static final Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static @Nullable Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DebugVMUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static @NonNull IStatus createStatus(int severity, String message) {
        return new Status(severity, PLUGIN_ID, 0, message, null);
    }

    public static @NonNull IStatus createErrorStatus(String message) {
        return DebugVMUIPlugin.createStatus(4, message);
    }

    public static void statusDialog(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                DebugVMUIPlugin.statusDialog(DebugVMUIMessages.StatusDialog_Error, status);
                break;
            }
            case 2: {
                DebugVMUIPlugin.statusDialog(DebugVMUIMessages.StatusDialog_Warning, status);
                break;
            }
            case 1: {
                DebugVMUIPlugin.statusDialog(DebugVMUIMessages.StatusDialog_Information, status);
            }
        }
    }

    public static void statusDialog(String title, IStatus status) {
        Shell shell = DebugVMUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            switch (status.getSeverity()) {
                case 4: {
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)status);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)status.getMessage());
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)status.getMessage());
                }
            }
        }
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry imageRegistry = super.createImageRegistry();
        imageRegistry.put("localVariable", this.imageDescriptor("localvar_obj.gif"));
        imageRegistry.put("thisVariable", this.imageDescriptor("thisvar_obj.gif"));
        imageRegistry.put("predefinedVariable", this.imageDescriptor("predefvar_obj.gif"));
        imageRegistry.put("modelParameter", this.imageDescriptor("modelpar_obj.gif"));
        imageRegistry.put("attribute", this.imageDescriptor("attribute_obj.gif"));
        imageRegistry.put("reference", this.imageDescriptor("reference_obj.gif"));
        imageRegistry.put("collectionElement", this.imageDescriptor("index_element_obj.gif"));
        imageRegistry.put("ExpressionInOCL", this.imageDescriptor("ExpressionInOCL.gif"));
        return imageRegistry;
    }

    private ImageDescriptor imageDescriptor(String imagePath) {
        return DebugVMUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + imagePath));
    }
}

