/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class InsertFloatingLabelFromMapCommand
extends AbstractCommand {
    private Diagram diagram;
    private Map<String, String> floatingLabelsMap;

    public InsertFloatingLabelFromMapCommand(Diagram diagram, Map<String, String> floatingLabelMap) {
        super("Migrate Class Diagram");
        this.diagram = diagram;
        this.floatingLabelsMap = floatingLabelMap;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        TreeIterator children = this.diagram.eAllContents();
        while (children.hasNext()) {
            View element;
            EObject object = (EObject)children.next();
            if (!(object instanceof View) || !this.floatingLabelsMap.containsKey((element = (View)object).getType())) continue;
            String floatingLabelVisualId = this.floatingLabelsMap.get(element.getType());
            boolean haveFloatingLabel = false;
            for (Object child : element.getChildren()) {
                if (!(child instanceof View) || !floatingLabelVisualId.equals(((View)child).getType())) continue;
                haveFloatingLabel = true;
            }
            if (haveFloatingLabel) continue;
            DecorationNode floatingLabel = NotationFactory.eINSTANCE.createDecorationNode();
            floatingLabel.setType(floatingLabelVisualId);
            Location location = NotationFactory.eINSTANCE.createLocation();
            location.setY(5);
            floatingLabel.setLayoutConstraint((LayoutConstraint)location);
            element.insertChild((View)floatingLabel);
        }
        return CommandResult.newOKCommandResult();
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        throw new ExecutionException("Should not be called, canRedo false");
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        throw new ExecutionException("Should not be called, canUndo false");
    }
}

