/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

public class InternationalizationAnnotationControlCommand
extends AbstractControlCommand {
    private static final String COMMAND_TITLE = "Annotation internationalization control command";
    private Resource oldNotationResource = null;

    public InternationalizationAnnotationControlCommand(ControlModeRequest request, Resource oldNotationResource) {
        super(COMMAND_TITLE, null, request);
        this.oldNotationResource = oldNotationResource;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = null;
        if (this.oldNotationResource == null) {
            commandResult = CommandResult.newErrorCommandResult((String)String.format("The source %s model does not exist", "notation"));
        } else {
            Resource newNotationResource = this.getTargetResource();
            if (newNotationResource == null) {
                commandResult = CommandResult.newErrorCommandResult((String)"The notation model has not been created");
            } else {
                EAnnotation annotation = null;
                for (EObject objectContent : this.oldNotationResource.getContents()) {
                    if (!(objectContent instanceof EAnnotation) || !"Internationalization".equals(((EAnnotation)objectContent).getSource())) continue;
                    annotation = (EAnnotation)EcoreUtil.copy((EObject)((EAnnotation)objectContent));
                }
                if (annotation != null) {
                    newNotationResource.getContents().add(annotation);
                    commandResult = CommandResult.newOKCommandResult((Object)newNotationResource);
                }
            }
        }
        return commandResult != null ? commandResult : CommandResult.newOKCommandResult();
    }

    protected Resource getTargetResource() {
        return this.request.getTargetResource("notation");
    }
}

