/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.AbstractTimelineLayoutPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Utils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class FirstEventRefreshEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String VIEW_REFRESH_ROLE = "ViewRefreshRole";
    private Element umlElement;

    public void activate() {
        this.umlElement = this.getUMLElement();
        if (this.umlElement == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.umlElement, (NotificationListener)this);
        this.refreshView();
    }

    public void deactivate() {
        if (this.umlElement == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.umlElement, (NotificationListener)this);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (editingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain);
        }
        return null;
    }

    protected Element getUMLElement() {
        View view = this.getView();
        if (view != null) {
            return (Element)view.getElement();
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    public void notifyChanged(Notification notification) {
        Object feature;
        if (notification.getEventType() == 1 && ((feature = notification.getFeature()) == UMLPackage.eINSTANCE.getTimeObservation_FirstEvent() || feature == UMLPackage.eINSTANCE.getTimeObservation_Event() || feature == UMLPackage.eINSTANCE.getTimeConstraint_FirstEvent() || feature == UMLPackage.eINSTANCE.getConstraint_ConstrainedElement())) {
            this.refreshView();
        }
    }

    public void refreshView() {
        CompartmentEditPart compartmentEditPart = EditPartUtils.findParentTimelineCompartment(this.getHost());
        Command command = compartmentEditPart.getCommand(AbstractTimelineLayoutPolicy.UPDATE_LAYOUT_REQUEST);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getView());
        Utils.executeLaterUnprotected(command, domain);
    }
}

