/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPropertySheetPageProvider;
import org.eclipse.papyrus.views.modelexplorer.handler.CollapseAllHandler;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProvider;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProviderService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.views.modelexplorer";
    private static Activator plugin;
    public static LogHelper log;

    public void start(BundleContext context) throws Exception {
        String workaround;
        IPropertySheetPageProviderService provider;
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
        EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        BundleContext bc = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference servreg = bc.getServiceReference(IPropertySheetPageProviderService.class);
        if (servreg != null && (provider = (IPropertySheetPageProviderService)bc.getService(servreg)) != null) {
            provider.registerPropertySheetPageProvider((IPropertySheetPageProvider)new ModelExplorerPropertySheetPageProvider());
        }
        if (System.getProperty(workaround = "eclipse.workaround.bug467000") == null) {
            System.setProperty(workaround, Boolean.toString(true));
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new CollapseAllHandler());
    }

    public static ImageDescriptor getImageDescriptor(String pathString) {
        Path path = new Path(pathString);
        URL uri = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
        if (uri == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)uri);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ICustomizationManager getCustomizationManager() {
        return ProviderHelper.getCustomizationManager();
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }
}

