/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.SynchronizedOverflowingLRUCache;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanReferenceVisitor;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.Util;

public class UseScanManager {
    private static UseScanCache fApiComponentCache;
    private static UseScanManager fUseScanProcessor;
    private static String tempLocation;
    public static final String STATE_DELIM = "*";
    public static final String LOCATION_DELIM = "|";
    public static final String ESCAPE_REGEX = "\\";
    public static final Pattern NAME_REGEX;
    public static final int DEFAULT_CACHE_SIZE = 1000;
    private String[] fLocations = null;
    static FileFilter USESCAN_FILTER;

    static {
        tempLocation = "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.api.tools/ApiUseScans/";
        NAME_REGEX = Pattern.compile("^.* \\(.*\\)$");
        USESCAN_FILTER = pathname -> {
            if (NAME_REGEX.matcher(pathname.getName()).matches()) {
                throw new RuntimeException(pathname.getName());
            }
            return false;
        };
    }

    private UseScanManager() {
    }

    public static synchronized UseScanManager getInstance() {
        if (fUseScanProcessor == null) {
            fUseScanProcessor = new UseScanManager();
            fApiComponentCache = new UseScanCache(1000);
        }
        return fUseScanProcessor;
    }

    public IReferenceDescriptor[] getExternalDependenciesFor(IApiComponent apiComponent, String[] apiUseTypes, IProgressMonitor monitor) {
        IReferenceCollection references = (IReferenceCollection)fApiComponentCache.get(apiComponent);
        if (references == null) {
            references = apiComponent.getExternalDependencies();
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.collecting_external_dependencies, (int)10);
        ArrayList<String> unavailableMembers = new ArrayList<String>();
        if (apiUseTypes != null && apiUseTypes.length > 0) {
            String[] stringArray = apiUseTypes;
            int n = apiUseTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String apiUseType = stringArray[n2];
                if (!references.hasReferencesTo(apiUseType)) {
                    unavailableMembers.add(apiUseType);
                }
                ++n2;
            }
            if (unavailableMembers.size() > 0) {
                this.fetch(apiComponent, unavailableMembers.toArray(new String[unavailableMembers.size()]), references, (IProgressMonitor)localmonitor.split(9));
            }
            localmonitor.setWorkRemaining(1).split(1);
            return references.getExternalDependenciesTo(apiUseTypes);
        }
        this.fetch(apiComponent, null, references, (IProgressMonitor)localmonitor.split(9));
        localmonitor.split(1);
        return references.getAllExternalDependencies();
    }

    private void fetch(IApiComponent apiComponent, String[] types, IReferenceCollection references, IProgressMonitor monitor) {
        block14: {
            UseScanParser parser = new UseScanParser();
            UseScanReferenceVisitor visitor = new UseScanReferenceVisitor(apiComponent, types, references);
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.load_external_dependencies, (int)10);
            try {
                String[] locations = this.fLocations == null ? this.getReportLocations() : this.fLocations;
                if (locations == null) break block14;
                IStringVariableManager stringManager = null;
                localmonitor.setWorkRemaining(locations.length);
                int i = 0;
                while (i < locations.length) {
                    block15: {
                        File file;
                        SubMonitor iterationMonitor;
                        block16: {
                            iterationMonitor = localmonitor.split(1);
                            file = new File(locations[i]);
                            if (!file.exists()) break block15;
                            if (!file.isFile()) break block16;
                            if (!Util.isArchive(file.getName())) break block15;
                            String destDirPath = String.valueOf(tempLocation) + file.getName() + '.' + file.getAbsolutePath().hashCode();
                            if (stringManager == null) {
                                stringManager = VariablesPlugin.getDefault().getStringVariableManager();
                            }
                            destDirPath = stringManager.performStringSubstitution(destDirPath);
                            locations[i] = String.valueOf(destDirPath) + '/' + file.lastModified();
                            File unzipDirLoc = new File(destDirPath);
                            if (unzipDirLoc.exists()) {
                                String[] childDirs;
                                String[] stringArray = childDirs = unzipDirLoc.list();
                                int n = childDirs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String childDir = stringArray[n2];
                                    if (!childDir.equals(String.valueOf(file.lastModified()))) {
                                        FileManager.getManager().recordTempFileRoot(String.valueOf(destDirPath) + '/' + childDir);
                                    }
                                    ++n2;
                                }
                            } else {
                                Util.unzip(file.getPath(), locations[i]);
                            }
                        }
                        try {
                            locations[i] = UseScanManager.getExactScanLocation(locations[i]);
                            if (locations[i] == null) {
                                String message = file.isDirectory() ? NLS.bind((String)SearchMessages.UseScanManager_InvalidDir, (Object)file.getAbsolutePath()) : NLS.bind((String)SearchMessages.UseScanManager_InvalidArchive, (Object)file.getAbsolutePath());
                                throw new Exception(message);
                            }
                            parser.parse(locations[i], (IProgressMonitor)iterationMonitor, visitor);
                        }
                        catch (Exception e) {
                            ApiPlugin.log(e);
                        }
                    }
                    ++i;
                }
                fApiComponentCache.remove(apiComponent);
                fApiComponentCache.put(apiComponent, references);
            }
            catch (Exception e) {
                ApiPlugin.log(e);
            }
        }
    }

    public static String getExactScanLocation(String location) {
        File file = new File(location);
        if (UseScanManager.isValidDirectory(file)) {
            return location;
        }
        file = new File(location, "xml");
        if (UseScanManager.isValidDirectory(file)) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static boolean isValidDirectory(File file) {
        if (file.exists() && file.isDirectory()) {
            try {
                file.listFiles(USESCAN_FILTER);
            }
            catch (RuntimeException rte) {
                File f = new File(file, rte.getMessage());
                try {
                    if (f.exists() && f.isDirectory()) {
                        f.listFiles(USESCAN_FILTER);
                    }
                }
                catch (RuntimeException runtimeException) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isValidArchive(File file) {
        String fname = file.getName().toLowerCase();
        if (file.exists() && Util.isArchive(fname)) {
            Enumeration<ZipEntry> entries;
            block27: {
                Object var4_6;
                Throwable throwable;
                entries = null;
                if (fname.endsWith(".jar")) {
                    try {
                        throwable = null;
                        var4_6 = null;
                        try (JarFile jfile = new JarFile(file);){
                            entries = jfile.entries();
                            break block27;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
                if (fname.endsWith(".zip")) {
                    try {
                        throwable = null;
                        var4_6 = null;
                        try (ZipFile zfile = new ZipFile(file);){
                            entries = zfile.entries();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    Path path;
                    int count;
                    ZipEntry o = (ZipEntry)entries.nextElement();
                    if (!o.isDirectory() || (count = (path = new Path(o.getName())).segmentCount()) <= 2) continue;
                    return NAME_REGEX.matcher(path.segment(0)).matches() || NAME_REGEX.matcher(path.segment(1)).matches();
                }
            }
        }
        return false;
    }

    public static boolean isValidScanLocation(String location) {
        if (location != null && location.length() > 0) {
            Path path = new Path(location);
            File file = path.toFile();
            return UseScanManager.isValidDirectory(file) || UseScanManager.isValidArchive(file);
        }
        return false;
    }

    public String[] getReportLocations() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        String apiUseScanPaths = node.get("API_USE_SCAN_LOCATION", null);
        if (apiUseScanPaths == null || apiUseScanPaths.length() == 0) {
            return new String[0];
        }
        String[] locations = apiUseScanPaths.split("\\|");
        ArrayList<String> locationList = new ArrayList<String>(locations.length);
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            String[] values = location.split("\\*");
            if (Boolean.parseBoolean(values[1])) {
                locationList.add(values[0]);
            }
            ++n2;
        }
        return locationList.toArray(new String[locationList.size()]);
    }

    public void setReportLocations(String[] locations) {
        this.fLocations = locations;
    }

    public void setCacheSize(int size) {
        fApiComponentCache.setSpaceLimit(size);
    }

    public void clearCache() {
        List elements = fApiComponentCache.elementsSnapshot();
        for (IReferenceCollection reference : elements) {
            reference.clear();
        }
        fApiComponentCache.flush();
    }

    private static class UseScanCache
    extends SynchronizedOverflowingLRUCache<IApiComponent, IReferenceCollection> {
        public UseScanCache(int size) {
            super(size);
        }

        public UseScanCache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry<IApiComponent, IReferenceCollection> entry) {
            IReferenceCollection references = (IReferenceCollection)entry.value;
            references.clear();
            return true;
        }

        protected UseScanCache newInstance(int size, int newOverflow) {
            return new UseScanCache(size, newOverflow);
        }
    }
}

