/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.job;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.composer.core.launch.ExecutableNotFoundException;
import org.eclipse.php.composer.core.launch.ScriptLauncher;
import org.eclipse.php.composer.core.launch.ScriptNotFoundException;
import org.eclipse.php.composer.core.launch.environment.ComposerEnvironmentFactory;
import org.eclipse.php.composer.core.launch.environment.Environment;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPlugin;
import org.eclipse.php.composer.ui.job.DownloadJob;
import org.eclipse.php.composer.ui.job.Messages;
import org.eclipse.php.composer.ui.job.runner.ComposerFailureMessageRunner;
import org.eclipse.php.composer.ui.job.runner.MissingExecutableRunner;
import org.eclipse.php.composer.ui.terminal.ComposerLauncher;
import org.eclipse.swt.widgets.Display;

public abstract class ComposerJob
extends Job {
    private IProject project;
    private IProgressMonitor monitor;
    private boolean cancelling = false;
    private ScriptLauncher launcher;
    protected static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.php.composer.core", Messages.ComposerJob_ErrorMessage);

    public ComposerJob(String name) {
        super(name);
    }

    public ComposerJob(IProject project, String name) {
        this(name);
        this.setProject(project);
    }

    public boolean belongsTo(Object family) {
        return Objects.equals(ComposerUIPlugin.FAMILY_COMPOSER, family) || Objects.equals(this.project, family) || this.project != null && Objects.equals(this.project.getName(), family);
    }

    protected void canceling() {
        if (this.cancelling || this.launcher == null || !this.monitor.isCanceled()) {
            return;
        }
        this.launcher.abort();
        this.monitor.done();
        this.cancelling = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean callDoOnLauncherRunException = false;
        try {
            this.monitor = monitor;
            boolean tryAgain = false;
            while (true) {
                try {
                    Environment env = new ComposerEnvironmentFactory().getEnvironment(this.getProject());
                    if (env == null) {
                        throw new ExecutableNotFoundException(Messages.ComposerJob_CannotFindExe);
                    }
                    this.launcher = new ComposerLauncher(env, this.getProject());
                    tryAgain = false;
                    continue;
                }
                catch (ExecutableNotFoundException e) {
                    MissingExecutableRunner runner = new MissingExecutableRunner();
                    Display.getDefault().syncExec((Runnable)runner);
                    if (runner.getReturnCode() == 0) {
                        tryAgain = true;
                        continue;
                    }
                    callDoOnLauncherRunException = true;
                    this.doOnLauncherRunException((Exception)((Object)e));
                    IStatus iStatus = Status.OK_STATUS;
                    monitor.done();
                    return iStatus;
                }
                catch (ScriptNotFoundException e) {
                    block15: {
                        callDoOnLauncherRunException = true;
                        this.doOnLauncherRunException((Exception)((Object)e));
                        if (!tryAgain) break block15;
                        Display.getDefault().asyncExec((Runnable)new ComposerFailureMessageRunner(Messages.ComposerJob_DownloadErrorMessage, monitor));
                        IStatus iStatus = Status.OK_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    try {
                        DownloadJob job = new DownloadJob(this.getProject());
                        job.schedule();
                        job.join();
                        tryAgain = true;
                        if (tryAgain) continue;
                        monitor.beginTask(this.getName(), -1);
                        monitor.worked(1);
                        this.launch(this.launcher);
                        monitor.worked(1);
                        if (this.getProject() != null) {
                            this.getProject().refreshLocal(2, null);
                            monitor.worked(1);
                        }
                    }
                    catch (Exception e2) {
                        if (!callDoOnLauncherRunException) {
                            callDoOnLauncherRunException = true;
                            this.doOnLauncherRunException(e2);
                        }
                        Logger.logException((Throwable)e2);
                        IStatus iStatus = ERROR_STATUS;
                        return iStatus;
                    }
                }
                break;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void doOnLauncherRunException(Exception e) {
    }

    protected abstract void launch(ScriptLauncher var1) throws IOException, InterruptedException, CoreException;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

